/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.ui.internal;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tea.core.internal.TaskProgressEstimationService;
import org.eclipse.tea.core.internal.model.TaskingModel;
import org.eclipse.tea.core.services.TaskProgressTracker;
import org.eclipse.tea.core.ui.Activator;
import org.osgi.service.component.annotations.Component;

@Component
public class TaskProgressEstimationImpl
implements TaskProgressEstimationService {
    private static final int RESOLUTION = 100;
    private static final AtomicInteger threadNo = new AtomicInteger(0);
    private final ExecutorService executor = Executors.newCachedThreadPool(r -> new Thread(r, "Tasking Progress Reporter " + threadNo.incrementAndGet()));
    private final Map<String, Future<?>> futures = new TreeMap();
    private final Map<String, Long> startTimes = new TreeMap<String, Long>();

    public int getEstimatedTicks(String id) {
        int pref = Activator.getInstance().getPreferenceStore().getInt(TaskProgressEstimationImpl.makeId(id));
        if (pref <= 0) {
            return 1;
        }
        return pref;
    }

    public long getEstimatedMillis(String id) {
        return this.getEstimatedTicks(id) * 100;
    }

    private void updateEstimation(String id, long runtime) {
        int newValue = (int)(runtime / 100L);
        int current = this.getEstimatedTicks(id);
        int estimate = newValue / 2 > current ? newValue : (current / 2 > newValue ? newValue : (newValue + current) / 2);
        IPreferenceStore preferenceStore = Activator.getInstance().getPreferenceStore();
        preferenceStore.setValue(TaskProgressEstimationImpl.makeId(id), estimate);
        if (preferenceStore instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)preferenceStore).save();
            }
            catch (Exception e) {
                Activator.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.tea.core.ui", "Cannot save task runtime estimation", (Throwable)e));
            }
        }
    }

    private static String makeId(String id) {
        return "tea.progress.estimation." + id;
    }

    public void begin(String id, TaskProgressTracker rootTracker) {
        this.futures.put(id, this.executor.submit(() -> {
            int currentEstimation = this.getEstimatedTicks(id);
            while (currentEstimation > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
                rootTracker.worked(1);
                --currentEstimation;
            }
        }));
        this.startTimes.put(id, System.currentTimeMillis());
    }

    public void finish(String id, IStatus status) {
        try {
            Future<?> future = this.futures.remove(id);
            if (future == null) {
                return;
            }
            future.cancel(true);
            Long start = this.startTimes.remove(id);
            if (start == null) {
                return;
            }
            if (status.getSeverity() < 4) {
                this.updateEstimation(id, System.currentTimeMillis() - start);
            }
        }
        catch (Exception e) {
            Activator.getInstance().getLog().log((IStatus)new Status(2, "org.eclipse.tea.core.ui", "Cannot finish progress tracking"));
        }
    }

    public String calculateId(Object task) {
        Method[] methodArray = task.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getAnnotation(TaskProgressTracker.TaskProgressProvider.class) != null) {
                return null;
            }
            ++n2;
        }
        String name = TaskingModel.getTaskName((Object)task);
        return name.replaceAll("[^A-Za-z0-9_.]+", "_");
    }
}

