/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.model;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public final class ParameterValue {
    public String value;
    private final Map<String, Param> parameters;

    ParameterValue(String fullString) {
        String[] elements = fullString.split(";");
        this.value = elements[0].trim();
        if (elements.length == 1) {
            this.parameters = Collections.emptyMap();
            return;
        }
        this.parameters = new TreeMap<String, Param>();
        int i = 1;
        while (i < elements.length) {
            String element = elements[i];
            String infix = ":=";
            int index = element.indexOf(infix);
            int len = 2;
            if (index < 0) {
                infix = "=";
                index = element.indexOf(infix);
                len = 1;
            }
            if (index < 0) {
                this.parameters.put(element.trim(), Param.EMPTY);
            } else {
                String key = element.substring(0, index).trim();
                String value = element.substring(index + len).trim();
                this.parameters.put(key, new Param(value, infix));
            }
            ++i;
        }
    }

    public static ParameterValue[] fromList(String[] list) {
        ParameterValue[] result = new ParameterValue[list.length];
        int i = 0;
        while (i < list.length) {
            result[i] = new ParameterValue(list[i]);
            ++i;
        }
        return result;
    }

    public static String[] valuesFromList(ParameterValue[] list) {
        String[] result = new String[list.length];
        int i = 0;
        while (i < list.length) {
            result[i] = list[i].value;
            ++i;
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(\"" + this.value + "\", " + String.valueOf(this.parameters) + ")";
    }

    public String getStringParameter(String key) {
        Param param = this.parameters.get(key);
        if (param == null) {
            return null;
        }
        String paramValue = param.value;
        if (paramValue.isEmpty()) {
            return paramValue;
        }
        int i1 = paramValue.indexOf(34);
        int i2 = paramValue.lastIndexOf(34);
        if (i1 != 0 || i2 != paramValue.length() - 1) {
            return paramValue;
        }
        if (++i1 >= i2) {
            return paramValue;
        }
        return paramValue.substring(i1, i2);
    }

    public void setStringParameter(String key, String value, String infix) {
        if (value == null) {
            this.parameters.remove(key);
        } else {
            this.parameters.put(key, new Param("\"" + value + "\"", infix));
        }
    }

    public String getEnumParameter(String key) {
        Param param = this.parameters.get(key);
        if (param == null) {
            return null;
        }
        return param.value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void write(Writer ps) throws IOException {
        ps.write(this.value);
        for (Map.Entry<String, Param> entry : this.parameters.entrySet()) {
            ps.write(59);
            ps.write(entry.getKey());
            Param param = entry.getValue();
            ps.write(param.infix);
            ps.write(param.value);
        }
    }

    void writeHtmlListelement(Writer w) throws IOException {
        w.write("<li>");
        w.write(this.value);
        if (!this.parameters.isEmpty()) {
            w.write(" <tt>");
            w.write(this.parameters.toString());
            w.write("</tt>");
        }
        w.write("</li>\n");
    }

    private static final class Param {
        private final String value;
        private final String infix;
        private static final Param EMPTY = new Param("", "");

        private Param(String value, String infix) {
            this.value = value;
            this.infix = infix;
        }
    }
}

