/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.examples.scripteditor;

import org.eclipse.actf.ai.internal.ui.scripteditor.PreviewPanel;
import org.eclipse.actf.examples.scripteditor.Activator;
import org.eclipse.actf.model.ui.editor.actions.FavoritesMenu;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private static ApplicationActionBarAdvisor ownInst = null;
    private MenuManager fileMenu = null;
    private FavoritesMenu favoritesMenu;
    private ActionFactory.IWorkbenchAction _preferenceAction;
    private ActionFactory.IWorkbenchAction _helpAction;
    private ActionFactory.IWorkbenchAction _aboutAction;
    private ActionFactory.IWorkbenchAction _quitAction;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
        ownInst = this;
    }

    public static ApplicationActionBarAdvisor getInstance() {
        return ownInst;
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.favoritesMenu = new FavoritesMenu(window, true);
        this._preferenceAction = ActionFactory.PREFERENCES.create(window);
        this._helpAction = ActionFactory.HELP_CONTENTS.create(window);
        this._aboutAction = ActionFactory.ABOUT.create(window);
        this._quitAction = ActionFactory.QUIT.create(window);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        this.fileMenu = new MenuManager(Activator.getResourceString("scripteditor.menu.file"), "file");
        this.fileMenu.add((IContributionItem)new Separator("fileOpenGroup"));
        this.fileMenu.add((IContributionItem)new Separator());
        this.fileMenu.add((IContributionItem)new Separator("fileCloseGroup"));
        this.fileMenu.add((IContributionItem)new Separator());
        this.fileMenu.add((IContributionItem)new Separator("fileSaveGroup"));
        this.fileMenu.add((IContributionItem)new Separator());
        this.fileMenu.add((IContributionItem)new Separator("movieGroup"));
        this.fileMenu.add((IContributionItem)new Separator());
        this.fileMenu.add((IContributionItem)new Separator("impExportGroup"));
        this.fileMenu.add((IContributionItem)new Separator());
        this.fileMenu.add((IAction)this._quitAction);
        menuBar.add((IContributionItem)this.fileMenu);
        MenuManager multimediaMenu = new MenuManager(Activator.getResourceString("scripteditor.menu.multimedia"), "multimedia");
        multimediaMenu.add((IContributionItem)new Separator("mediaMovieGroup"));
        multimediaMenu.add((IContributionItem)new Separator());
        multimediaMenu.add((IContributionItem)new Separator("mediaAudioGroup"));
        multimediaMenu.add((IContributionItem)new Separator());
        multimediaMenu.add((IContributionItem)new Separator("mediaAudioCaptureGroup"));
        multimediaMenu.add((IContributionItem)new Separator());
        menuBar.add((IContributionItem)multimediaMenu);
        MenuManager captureModeSubMenu = new MenuManager(Activator.getResourceString("scripteditor.menu.multimedia.capturemode"), "capturemode");
        captureModeSubMenu.add((IContributionItem)new Separator("captureAudioModeGroup"));
        captureModeSubMenu.add((IContributionItem)new Separator());
        captureModeSubMenu.add((IContributionItem)new Separator("captureAudioClearGroup"));
        captureModeSubMenu.add((IContributionItem)new Separator());
        multimediaMenu.add((IContributionItem)captureModeSubMenu);
        menuBar.add((IContributionItem)this.favoritesMenu);
        MenuManager windowMenu = new MenuManager(Activator.getResourceString("scripteditor.menu.window"), "window");
        windowMenu.add((IContributionItem)new Separator("navStart"));
        windowMenu.add((IContributionItem)new Separator("navEnd"));
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)this._preferenceAction);
        menuBar.add((IContributionItem)windowMenu);
        MenuManager helpMenu = new MenuManager(Activator.getResourceString("scripteditor.menu.help"), "help");
        helpMenu.add((IContributionItem)new Separator("helpStart"));
        helpMenu.add((IAction)this._helpAction);
        helpMenu.add((IContributionItem)new Separator("helpEnd"));
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IAction)this._aboutAction);
        menuBar.add((IContributionItem)helpMenu);
        this.register((IAction)this._preferenceAction);
        this.register((IAction)this._helpAction);
        this.register((IAction)this._aboutAction);
        this.register((IAction)this._quitAction);
    }

    public void setFileMenuListener() {
        this.fileMenu.getMenu().addMenuListener((MenuListener)new FileMenuAdapter());
    }

    public void fillStatusLine(IStatusLineManager statusLine) {
        super.fillStatusLine(statusLine);
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        super.fillCoolBar(coolBar);
    }

    private class FileMenuAdapter
    extends MenuAdapter {
        private FileMenuAdapter() {
        }

        public void menuShown(MenuEvent e) {
            boolean newStat = PreviewPanel.getInstance().getCurrentStatusMedia();
            Menu menu = (Menu)e.getSource();
            MenuItem[] items = menu.getItems();
            int i = 0;
            while (i < items.length) {
                String str = items[i].getText();
                if (str != "" && !Activator.getResourceString("scripteditor.action.reload").equals(str) && !Activator.getResourceString("scripteditor.action.exit").equals(str)) {
                    items[i].setEnabled(newStat);
                }
                ++i;
            }
        }
    }
}

