/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.apt.internal.preferences;

import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.m2e.apt.preferences.AnnotationProcessingMode;
import org.eclipse.m2e.apt.preferences.IPreferencesManager;
import org.eclipse.m2e.apt.preferences.PreferencesConstants;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesManager
implements IPreferencesManager {
    private static final Logger log = LoggerFactory.getLogger(PreferencesManager.class);
    private static final Properties EMPTY = new Properties();

    public PreferencesManager() {
        DefaultScope.INSTANCE.getNode("org.eclipse.m2e.apt");
    }

    @Override
    public void setAnnotationProcessorMode(IProject project, AnnotationProcessingMode mode) {
        IEclipsePreferences prefs = this.getPreferences(project);
        prefs.put("org.eclipse.m2e.apt.mode", mode.toString());
        this.save(prefs);
    }

    private void save(IEclipsePreferences prefs) {
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            log.error("Error saving preferences", (Throwable)e);
        }
    }

    @Override
    public AnnotationProcessingMode getAnnotationProcessorMode(IProject project) {
        String mode = this.getString(project, "org.eclipse.m2e.apt.mode");
        if (mode == null) {
            mode = PreferencesConstants.DEFAULT_OPTIONS.get("org.eclipse.m2e.apt.mode");
        }
        return AnnotationProcessingMode.getFromString(mode);
    }

    private String getString(IProject project, String optionName) {
        if (project == null) {
            return this.getString(PreferencesManager.getWorkspaceContexts(), optionName);
        }
        String value = new ProjectScope(project).getNode("org.eclipse.m2e.apt").get(optionName, null);
        if (value == null) {
            value = this.getStringFromMavenProps(project, optionName);
        }
        if (value == null) {
            value = this.getString(PreferencesManager.getWorkspaceContexts(), optionName);
        }
        return value;
    }

    private String getStringFromMavenProps(IProject project, String optionName) {
        if ("org.eclipse.m2e.apt.mode".equals(optionName)) {
            AnnotationProcessingMode mode = this.getPomAnnotationProcessorMode(project);
            return mode == null ? null : mode.name();
        }
        if ("org.eclipse.m2e.apt.aptProcessDuringReconcile".equals(optionName)) {
            return this.getPomAnnotationProcessDuringReconcile(project);
        }
        return null;
    }

    private static IScopeContext[] getWorkspaceContexts() {
        return new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
    }

    private String getString(IScopeContext[] contexts, String optionName) {
        if (contexts == null) {
            return null;
        }
        IPreferencesService service = Platform.getPreferencesService();
        return service.getString("org.eclipse.m2e.apt", optionName, null, contexts);
    }

    private IEclipsePreferences getPreferences(IProject project) {
        Object scopeContext = project == null ? InstanceScope.INSTANCE : new ProjectScope(project);
        return scopeContext.getNode("org.eclipse.m2e.apt");
    }

    @Override
    public boolean hasSpecificProjectSettings(IProject project) {
        if (project != null) {
            Preferences[] prefs = new Preferences[]{new ProjectScope(project).getNode("org.eclipse.m2e.apt")};
            IPreferencesService service = Platform.getPreferencesService();
            for (String optionName : PreferencesConstants.DEFAULT_OPTIONS.keySet()) {
                if (service.get(optionName, null, prefs) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void clearSpecificSettings(IProject project) {
        if (project != null) {
            try {
                IEclipsePreferences prefs = new ProjectScope(project).getNode("org.eclipse.m2e.apt");
                prefs.clear();
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                log.error("Error saving " + project.getName() + "preferences", (Throwable)ex);
            }
        }
    }

    private static Properties getMavenProperties(IProject project) {
        try {
            if (!project.isAccessible() || !project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                return EMPTY;
            }
            IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getProject(project);
            if (facade == null) {
                IFile pom = project.getFile("pom.xml");
                facade = MavenPlugin.getMavenProjectRegistry().create(pom, true, (IProgressMonitor)new NullProgressMonitor());
            }
            if (facade != null) {
                MavenProject mavenProject = facade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
                return mavenProject.getProperties();
            }
        }
        catch (CoreException ex) {
            log.error("Error loading maven project for " + project.getName(), (Throwable)ex);
        }
        return EMPTY;
    }

    @Override
    public AnnotationProcessingMode getPomAnnotationProcessorMode(IProject project) {
        if (project != null) {
            Properties properties = PreferencesManager.getMavenProperties(project);
            return AnnotationProcessingMode.getFromStringOrNull(properties.getProperty("m2e.apt.activation"));
        }
        return null;
    }

    @Override
    public String getPomAnnotationProcessDuringReconcile(IProject project) {
        if (project != null) {
            Properties properties = PreferencesManager.getMavenProperties(project);
            return properties.getProperty("m2e.apt.processDuringReconcile");
        }
        return null;
    }

    @Override
    public void setAnnotationProcessDuringReconcile(IProject project, boolean enable) {
        IEclipsePreferences prefs = this.getPreferences(project);
        prefs.put("org.eclipse.m2e.apt.aptProcessDuringReconcile", String.valueOf(enable));
        this.save(prefs);
    }

    @Override
    public boolean shouldEnableAnnotationProcessDuringReconcile(IProject project) {
        String option = this.getString(project, "org.eclipse.m2e.apt.aptProcessDuringReconcile");
        if (option == null) {
            option = PreferencesConstants.DEFAULT_OPTIONS.get("org.eclipse.m2e.apt.aptProcessDuringReconcile");
        }
        return option.equalsIgnoreCase("true");
    }
}

