/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.apt.internal.processor;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Scanner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.MojoExecutionBuildParticipant;
import org.sonatype.plexus.build.incremental.BuildContext;

public class MavenProcessorBuildParticipant
extends MojoExecutionBuildParticipant {
    public MavenProcessorBuildParticipant(MojoExecution execution) {
        super(execution, true);
    }

    public Set<IProject> build(int kind, IProgressMonitor monitor) throws Exception {
        BuildContext buildContext = this.getBuildContext();
        monitor.setTaskName("Executing " + this.getMojoExecution().getArtifactId() + ":" + this.getMojoExecution().getGoal());
        IMavenProjectFacade mavenFacade = this.getMavenProjectFacade();
        MavenProject mavenProject = mavenFacade.getMavenProject();
        if (!buildContext.hasDelta(mavenFacade.getPomFile())) {
            File source = this.getFileParameter("sourceDirectory", mavenProject);
            Scanner ds = buildContext.newScanner(source);
            ds.scan();
            String[] includedFiles = ds.getIncludedFiles();
            if (includedFiles == null || includedFiles.length <= 0) {
                return null;
            }
            if (this.getBuildContext().isIncremental() && Arrays.stream(includedFiles).noneMatch(f -> f.endsWith(".java"))) {
                return Collections.emptySet();
            }
        }
        Set result = super.build(kind, monitor);
        File generated = this.getFileParameter("outputDirectory", mavenProject);
        if (generated == null) {
            generated = this.getFileParameter("defaultOutputDirectory", mavenProject);
        }
        if (generated != null) {
            buildContext.refresh(generated);
        }
        return result;
    }

    private File getFileParameter(String propertyId, MavenProject mavenProject) throws CoreException {
        IMaven maven = MavenPlugin.getMaven();
        return (File)maven.getMojoParameterValue(mavenProject, this.getMojoExecution(), propertyId, File.class, null);
    }
}

