/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.core.operations;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.core.operations.Operation;
import org.eclipse.mylyn.internal.commons.core.CommonsCorePlugin;
import org.eclipse.mylyn.internal.commons.core.operations.NullOperationMonitor;
import org.eclipse.mylyn.internal.commons.core.operations.OperationMonitor;

public class OperationUtil {
    private static final int POLL_INTERVAL = 500;

    public static IOperationMonitor convert(IProgressMonitor monitor) {
        return OperationUtil.convert(monitor, "", 0);
    }

    public static IOperationMonitor convert(IProgressMonitor monitor, int work) {
        return OperationUtil.convert(monitor, "", work);
    }

    public static IOperationMonitor convert(IProgressMonitor monitor, String taskName, int work) {
        if (monitor instanceof IOperationMonitor) {
            return (IOperationMonitor)monitor;
        }
        if (monitor == null) {
            return new NullOperationMonitor();
        }
        return new OperationMonitor(null, monitor, taskName, work);
    }

    public static boolean isBackgroundMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            return false;
        }
        if (monitor instanceof IOperationMonitor) {
            return ((IOperationMonitor)monitor).hasFlag(IOperationMonitor.OperationFlag.BACKGROUND);
        }
        return monitor.getClass().getSimpleName().equals("BackgroundProgressMonitor");
    }

    public static synchronized ExecutorService getExecutorService() {
        return CommonsCorePlugin.getExecutorService();
    }

    @Deprecated
    public static <T> T execute(IProgressMonitor monitor, Operation<T> request) throws Throwable {
        SubMonitor s;
        SubMonitor subMonitor = monitor instanceof SubMonitor ? (s = (SubMonitor)monitor) : SubMonitor.convert(null);
        Future<T> future = OperationUtil.getExecutorService().submit(request);
        while (true) {
            if (monitor.isCanceled()) {
                request.abort();
                future.cancel(false);
                try {
                    if (!future.isCancelled()) {
                        future.get();
                    }
                }
                catch (InterruptedException | CancellationException | ExecutionException exception) {
                    // empty catch block
                }
                throw new OperationCanceledException();
            }
            try {
                return future.get(500L, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException e) {
                throw new OperationCanceledException();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
            catch (TimeoutException timeoutException) {
                subMonitor.setWorkRemaining(20);
                subMonitor.worked(1);
                continue;
            }
            break;
        }
    }
}

