/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.workbench;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.editors.CommonTextSupport;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;

public class WorkbenchActionSupport
implements ISelectionChangedListener {
    private WorkbenchActionCallback callback;
    private final GlobalAction copyAction;
    private final GlobalAction cutAction = new GlobalAction(ActionFactory.CUT.getId());
    private final GlobalAction findAction;
    private final GlobalAction pasteAction;
    private final GlobalAction redoAction;
    private final GlobalAction selectAllAction;
    private final GlobalAction undoAction;

    public WorkbenchActionSupport() {
        this.cutAction.setText(WorkbenchMessages.Workbench_cut);
        this.cutAction.setToolTipText(WorkbenchMessages.Workbench_cutToolTip);
        this.cutAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_CUT"));
        this.cutAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_CUT"));
        this.cutAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_CUT_DISABLED"));
        this.cutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.pasteAction = new GlobalAction(ActionFactory.PASTE.getId());
        this.pasteAction.setText(WorkbenchMessages.Workbench_paste);
        this.pasteAction.setToolTipText(WorkbenchMessages.Workbench_pasteToolTip);
        this.pasteAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_PASTE"));
        this.pasteAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_PASTE"));
        this.pasteAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_PASTE_DISABLED"));
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.copyAction = new GlobalAction(ActionFactory.COPY.getId());
        this.copyAction.setText(WorkbenchMessages.Workbench_copy);
        this.copyAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_COPY"));
        this.copyAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_COPY"));
        this.copyAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.undoAction = new GlobalAction(ActionFactory.UNDO.getId());
        this.undoAction.setText(WorkbenchMessages.Workbench_undo);
        this.undoAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_UNDO"));
        this.undoAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_UNDO"));
        this.undoAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_UNDO_DISABLED"));
        this.undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.redoAction = new GlobalAction(ActionFactory.REDO.getId());
        this.redoAction.setText(WorkbenchMessages.Workbench_redo);
        this.redoAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_REDO"));
        this.redoAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_REDO"));
        this.redoAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_REDO_DISABLED"));
        this.redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
        this.selectAllAction = new GlobalAction(ActionFactory.SELECT_ALL.getId());
        this.selectAllAction.setText(WorkbenchMessages.Workbench_selectAll);
        this.selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.selectAllAction.setEnabled(true);
        this.findAction = new GlobalAction(ActionFactory.FIND.getId());
        this.findAction.setText(WorkbenchMessages.Workbench_findReplace);
        this.findAction.setImageDescriptor(CommonImages.FIND);
        this.findAction.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
    }

    public void contributeActions(IMenuManager manager) {
        manager.add((IAction)this.undoAction);
        manager.add((IAction)this.redoAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.cutAction);
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.pasteAction);
        manager.add((IAction)this.selectAllAction);
        manager.add((IContributionItem)new Separator());
    }

    public void forceEditActionsEnabled() {
        this.cutAction.setEnabled(true);
        this.copyAction.setEnabled(true);
        this.pasteAction.setEnabled(true);
        this.selectAllAction.setEnabled(true);
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
    }

    public WorkbenchActionCallback getCallback() {
        return this.callback;
    }

    public Action getCopyAction() {
        return this.copyAction;
    }

    public Action getCutAction() {
        return this.cutAction;
    }

    public Action getFindAction() {
        return this.findAction;
    }

    public Action getPasteAction() {
        return this.pasteAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    public Action getSelectAllAction() {
        return this.selectAllAction;
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public void install(IActionBars bars) {
        bars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        bars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllAction);
        bars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)this.findAction);
        bars.updateActionBars();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof TextSelection) {
            this.updateActions(event.getSelection());
        } else if (selection.isEmpty()) {
            this.forceEditActionsEnabled();
        }
    }

    public void setCallback(WorkbenchActionCallback callback) {
        this.callback = callback;
    }

    public void uninstall(IActionBars bars) {
        bars.setGlobalActionHandler(ActionFactory.CUT.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.REDO.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.FIND.getId(), null);
        bars.updateActionBars();
    }

    public void updateActions(ISelection selection) {
        this.cutAction.selectionChanged(selection);
        this.copyAction.selectionChanged(selection);
        this.pasteAction.selectionChanged(selection);
        this.undoAction.selectionChanged(selection);
        this.redoAction.selectionChanged(selection);
        this.selectAllAction.selectionChanged(selection);
        this.findAction.selectionChanged(selection);
    }

    private class GlobalAction
    extends Action {
        private final String actionId;

        public GlobalAction(String actionId) {
            this.actionId = actionId;
        }

        public void run() {
            if (WorkbenchActionSupport.this.callback != null) {
                WorkbenchActionSupport.this.callback.doAction(this.actionId, WorkbenchActionSupport.this.callback.getFocusControl());
                WorkbenchActionSupport.this.updateActions(WorkbenchActionSupport.this.callback.getSelection());
            }
        }

        public void selectionChanged(ISelection selection) {
            if (WorkbenchActionSupport.this.callback != null) {
                this.setEnabled(WorkbenchActionSupport.this.callback.canPerformAction(this.actionId, WorkbenchActionSupport.this.callback.getFocusControl()));
            } else {
                this.setEnabled(false);
            }
        }
    }

    public static class WorkbenchActionCallback {
        public boolean canPerformAction(String actionId, Control control) {
            return CommonTextSupport.canPerformAction(actionId, control);
        }

        public void doAction(String actionId, Control control) {
            CommonTextSupport.doAction(actionId, control);
        }

        public Control getFocusControl() {
            return Display.getDefault().getFocusControl();
        }

        public ISelection getSelection() {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && window.getSelectionService() != null) {
                return window.getSelectionService().getSelection();
            }
            return null;
        }
    }
}

