/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.semanticTokens;

import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.tm4e.ui.text.TMPresentationReconciler;
import org.eclipse.tm4e.ui.themes.ITokenProvider;

abstract class TokenTypeMapper
implements Function<String, IToken> {
    private static final TokenTypeMapper NO_OP = new TokenTypeMapper(){

        @Override
        public @Nullable IToken apply(String tokenType) {
            return null;
        }
    };

    TokenTypeMapper() {
    }

    public static TokenTypeMapper create(ITextViewer viewer) {
        try {
            return new TM4ETokenTypeMapper(viewer);
        }
        catch (NoClassDefFoundError ex) {
            return NO_OP;
        }
    }

    private static final class TM4ETokenTypeMapper
    extends TokenTypeMapper {
        private final ITextViewer viewer;
        private @Nullable TMPresentationReconciler tmPresentationReconciler;

        TM4ETokenTypeMapper(ITextViewer viewer) {
            this.viewer = viewer;
        }

        @Override
        public @Nullable IToken apply(String tokenType) {
            ITokenProvider theme;
            if (this.tmPresentationReconciler == null) {
                this.tmPresentationReconciler = TMPresentationReconciler.getTMPresentationReconciler((ITextViewer)this.viewer);
            }
            if (this.tmPresentationReconciler != null && (theme = this.tmPresentationReconciler.getTokenProvider()) != null) {
                return theme.getToken(tokenType);
            }
            return null;
        }
    }
}

