/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.lib;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class XcoreEListExtensions {
    @Inline(value="$2.$3unmodifiableEList($1)", imported={ECollections.class})
    public static <T> EList<T> unmodifiableView(EList<? extends T> list) {
        return ECollections.unmodifiableEList(list);
    }

    public static <T> EList<T> immutableCopy(EList<? extends T> list) {
        Object[] elements = list.toArray();
        return new UnmodiableArrayView(elements);
    }

    public static <T extends Comparable<? super T>> EList<T> sortInplace(EList<T> list) {
        ECollections.sort(list);
        return list;
    }

    public static <T> EList<T> sortInplace(EList<T> list, Comparator<? super T> comparator) {
        ECollections.sort(list, comparator);
        return list;
    }

    public static <T, C extends Comparable<? super C>> EList<T> sortInplaceBy(EList<T> list, final Functions.Function1<? super T, C> key) {
        Comparator comparator = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Comparable left = (Comparable)key.apply(o1);
                Comparable right = (Comparable)key.apply(o2);
                return left.compareTo(right);
            }
        };
        ECollections.sort(list, (Comparator)comparator);
        return list;
    }

    @Pure
    public static <T> EList<T> reverseView(EList<T> list) {
        return ECollections.asEList((List)Lists.reverse(list));
    }

    public static <T> EList<T> reverse(EList<T> list) {
        ECollections.reverse(list);
        return list;
    }

    @Pure
    public static <T, R> EList<R> map(EList<T> list, Functions.Function1<? super T, ? extends R> transformation) {
        return ECollections.asEList((List)ListExtensions.map(list, transformation));
    }

    static class UnmodiableArrayView<T>
    extends BasicEList<T> {
        private static final long serialVersionUID = 1L;

        UnmodiableArrayView(Object[] data) {
            super(data.length, data);
        }

        public void setData(int size, Object[] data) {
            throw new UnsupportedOperationException();
        }

        public void grow(int minimumCapacity) {
            throw new UnsupportedOperationException();
        }

        public void shrink() {
            throw new UnsupportedOperationException();
        }

        public T setUnique(int index, T object) {
            throw new UnsupportedOperationException();
        }

        public T remove(int index) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

