/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.discovery.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Overview;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.AbstractDiscoveryItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogViewer;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class DiscoveryItem<T extends CatalogItem>
extends AbstractDiscoveryItem<T>
implements PropertyChangeListener {
    Button checkbox;
    private Composite checkboxContainer;
    private final CatalogItem item;
    private Label description;
    private Label iconLabel;
    private ToolItem infoButton;
    private Label nameLabel;
    private Link providerLabel;
    private final IShellProvider shellProvider;
    private final CatalogViewer viewer;

    public DiscoveryItem(Composite parent, int style, DiscoveryResources resources, IShellProvider shellProvider, T item, CatalogViewer viewer) {
        super(parent, style, resources, item);
        this.shellProvider = shellProvider;
        this.item = item;
        this.viewer = viewer;
        item.addPropertyChangeListener((PropertyChangeListener)this);
        this.addDisposeListener(e -> item.removePropertyChangeListener((PropertyChangeListener)this));
        this.createContent();
        this.initializeListeners();
    }

    private void createContent() {
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 7;
        layout.marginTop = 2;
        layout.marginBottom = 2;
        this.setLayout((Layout)layout);
        this.checkboxContainer = new Composite((Composite)this, 0);
        GridDataFactory.swtDefaults().align(0x1000000, 1).span(1, 2).applyTo((Control)this.checkboxContainer);
        GridLayoutFactory.fillDefaults().spacing(1, 1).numColumns(2).applyTo(this.checkboxContainer);
        this.checkbox = new Button(this.checkboxContainer, 34);
        this.checkbox.setSelection(this.item.isSelected());
        this.checkbox.setText(" ");
        this.checkbox.setData("connectorId", (Object)this.item.getId());
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.checkbox);
        this.iconLabel = new Label(this.checkboxContainer, 0);
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.iconLabel);
        if (this.item.getIcon() != null) {
            this.iconLabel.setImage(this.resources.getIconImage(this.item.getSource(), this.item.getIcon(), 32, false));
        }
        this.nameLabel = new Label((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(1, 0x1000000).applyTo((Control)this.nameLabel);
        this.nameLabel.setFont(this.resources.getSmallHeaderFont());
        if (this.item.isInstalled()) {
            this.nameLabel.setText(NLS.bind((String)Messages.DiscoveryItem_Extension_installed, (Object)this.item.getName()));
        } else {
            this.nameLabel.setText(this.item.getName());
        }
        if (this.hasTooltip()) {
            ToolBar toolBar = new ToolBar((Composite)this, 0x800000);
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)toolBar);
            this.infoButton = new ToolItem(toolBar, 8);
            this.infoButton.setImage(this.resources.getInfoImage());
            this.infoButton.setToolTipText(Messages.ConnectorDiscoveryWizardMainPage_tooltip_showOverview);
            this.hookTooltip((Control)toolBar, (Widget)this.infoButton, (Control)this, (Control)this.nameLabel, this.item.getSource(), this.item.getOverview(), null);
        } else {
            Label label = new Label((Composite)this, 0);
            label.setText(" ");
        }
        this.description = new Label((Composite)this, 64);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).hint(100, -1).applyTo((Control)this.description);
        String descriptionText = this.item.getDescription();
        int maxDescriptionLength = 162;
        if (descriptionText == null) {
            descriptionText = "";
        }
        if (descriptionText.length() > maxDescriptionLength) {
            descriptionText = descriptionText.substring(0, maxDescriptionLength);
        }
        this.description.setText(descriptionText.replaceAll("(\\r\\n)|\\n|\\r", " "));
        this.createProviderLabel();
    }

    public void createProviderLabel() {
        this.providerLabel = new Link((Composite)this, 131072);
        GridDataFactory.fillDefaults().span(3, 1).align(1, 0x1000000).applyTo((Control)this.providerLabel);
        this.providerLabel.setForeground(this.resources.getColorDisabled());
        if (this.item.getCertification() != null) {
            this.providerLabel.setText(NLS.bind((String)Messages.DiscoveryViewer_Certification_Label0, (Object[])new String[]{this.item.getProvider(), this.item.getLicense(), this.item.getCertification().getName()}));
            if (this.item.getCertification().getUrl() != null) {
                this.providerLabel.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> WorkbenchUtil.openUrl(this.item.getCertification().getUrl(), 128)));
            }
            Overview overview = new Overview();
            overview.setSummary(this.item.getCertification().getDescription());
            overview.setUrl(this.item.getCertification().getUrl());
            Image image = this.resources.getIconImage(this.item.getSource(), this.item.getCertification().getIcon(), 48, true);
            this.hookTooltip((Control)this.providerLabel, (Widget)this.providerLabel, (Control)this, (Control)this.providerLabel, this.item.getSource(), overview, image);
        } else if (this.item.getLicense() != null) {
            this.providerLabel.setText(NLS.bind((String)Messages.ConnectorDiscoveryWizardMainPage_provider_and_license, (Object)this.item.getProvider(), (Object)this.item.getLicense()));
        } else {
            this.providerLabel.setText(this.item.getProvider());
        }
    }

    protected boolean hasTooltip() {
        return this.item.getOverview() != null && this.item.getOverview().getSummary() != null && this.item.getOverview().getSummary().length() > 0;
    }

    public void initializeListeners() {
        this.checkbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                boolean selected = DiscoveryItem.this.checkbox.getSelection();
                DiscoveryItem.this.maybeModifySelection(selected);
            }
        });
        MouseListener connectorItemMouseListener = MouseListener.mouseUpAdapter(e -> {
            boolean selected;
            boolean bl = selected = !this.checkbox.getSelection();
            if (this.maybeModifySelection(selected)) {
                this.checkbox.setSelection(selected);
            }
        });
        this.checkboxContainer.addMouseListener(connectorItemMouseListener);
        this.addMouseListener(connectorItemMouseListener);
        this.iconLabel.addMouseListener(connectorItemMouseListener);
        this.nameLabel.addMouseListener(connectorItemMouseListener);
        this.description.addMouseListener(connectorItemMouseListener);
    }

    protected boolean maybeModifySelection(boolean selected) {
        if (selected) {
            if (this.item.isInstalled()) {
                MessageDialog.openWarning((Shell)this.shellProvider.getShell(), (String)Messages.DiscoveryItem_Connector_already_installed_Error_Title, (String)NLS.bind((String)Messages.DiscoveryItem_Connector_already_installed_Error_Message, (Object)this.item.getName()));
                return false;
            }
            if (this.item.getAvailable() != null && !this.item.getAvailable().booleanValue()) {
                MessageDialog.openWarning((Shell)this.shellProvider.getShell(), (String)Messages.ConnectorDiscoveryWizardMainPage_warningTitleConnectorUnavailable, (String)NLS.bind((String)Messages.ConnectorDiscoveryWizardMainPage_warningMessageConnectorUnavailable, (Object)this.item.getName()));
                return false;
            }
        }
        this.viewer.modifySelection(this.item, selected);
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(() -> {
                if (!this.isDisposed()) {
                    this.refresh();
                }
            });
        }
    }

    @Override
    protected void refresh() {
        boolean enabled = !this.item.isInstalled() && (this.item.getAvailable() == null || this.item.getAvailable() != false);
        this.checkbox.setEnabled(enabled);
        this.nameLabel.setEnabled(enabled);
        this.providerLabel.setEnabled(enabled);
        this.description.setEnabled(enabled);
        Color foreground = enabled ? this.getForeground() : this.resources.getColorDisabled();
        this.nameLabel.setForeground(foreground);
        this.description.setForeground(foreground);
    }
}

