/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.start;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.JobFamilies;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryInitializer;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.ResourceRefreshHandler;
import org.eclipse.egit.core.internal.efs.HiddenResources;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.core.op.IgnoreOperation;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryFinder;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.WorkingTreeModifiedListener;
import org.eclipse.jgit.util.FS;
import org.eclipse.team.core.RepositoryProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component
public class WorkspaceConnector {
    private IWorkspace workspace;
    private IPreferencesService preferencesService;
    private RepositoryCache repositoryCache;
    private ListenerHandle refreshHandle;
    private LinkedList<GitResourcChangeListener> listeners = new LinkedList();
    private Job hiddenResourcesInitializer;

    @Reference
    void setWorkspace(IWorkspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    void setPreferencesService(IPreferencesService service) {
        this.preferencesService = service;
    }

    @Reference
    void setRepositoryCache(RepositoryCache cache) {
        this.repositoryCache = cache;
    }

    @Activate
    void start() {
        GitProjectData.attachToWorkspace();
        this.refreshHandle = this.repositoryCache.getGlobalListenerList().addWorkingTreeModifiedListener((WorkingTreeModifiedListener)new ResourceRefreshHandler());
        this.registerAutoIgnoreDerivedResources();
        this.registerAutoShareProjects();
        this.registerPreDeleteResourceChangeListener();
        this.registerBuiltinLFS();
        this.hiddenResourcesInitializer = Job.createSystem((String)CoreText.HiddenResources_InitJobName, HiddenResources.INSTANCE::initialize);
        this.hiddenResourcesInitializer.setUser(false);
        this.hiddenResourcesInitializer.schedule();
    }

    @Deactivate
    void shutDown() {
        if (this.listeners != null) {
            LinkedList<GitResourcChangeListener> toClose = this.listeners;
            this.listeners = null;
            toClose.forEach(arg_0 -> ((IWorkspace)this.workspace).removeResourceChangeListener(arg_0));
            toClose.forEach(l -> l.stop());
            toClose.clear();
        }
        if (this.refreshHandle != null) {
            this.refreshHandle.remove();
            this.refreshHandle = null;
        }
        if (this.hiddenResourcesInitializer != null) {
            this.hiddenResourcesInitializer.cancel();
            try {
                this.hiddenResourcesInitializer.join();
            }
            catch (InterruptedException e) {
                Activator.logError(e.getLocalizedMessage(), e);
            }
            this.hiddenResourcesInitializer = null;
        }
        GitProjectData.detachFromWorkspace();
    }

    private void registerAutoShareProjects() {
        AutoShareProjects autoShareListener = new AutoShareProjects(this.preferencesService);
        this.listeners.push(autoShareListener);
        this.workspace.addResourceChangeListener((IResourceChangeListener)autoShareListener, 1);
    }

    private void registerAutoIgnoreDerivedResources() {
        IgnoreDerivedResources ignoreDerivedResourcesListener = new IgnoreDerivedResources(this.preferencesService);
        this.listeners.push(ignoreDerivedResourcesListener);
        this.workspace.addResourceChangeListener((IResourceChangeListener)ignoreDerivedResourcesListener, 1);
    }

    private void registerPreDeleteResourceChangeListener() {
        GitReleaseListener deleteProjectListener = new GitReleaseListener();
        this.listeners.push(deleteProjectListener);
        this.workspace.addResourceChangeListener((IResourceChangeListener)deleteProjectListener, 4);
    }

    private void registerBuiltinLFS() {
        if (Platform.getBundle((String)"org.eclipse.jgit.lfs") != null) {
            try {
                Class<?> lfs = Class.forName("org.eclipse.jgit.lfs.BuiltinLFS");
                if (lfs != null) {
                    lfs.getMethod("register", new Class[0]).invoke(null, new Object[0]);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                Activator.logWarning(CoreText.Activator_noBuiltinLfsSupportDetected, e1);
            }
        }
    }

    private static class AutoShareProjects
    extends GitResourcChangeListener {
        private static int INTERESTING_CHANGES = 16385;
        private final CheckProjectsToShare checkProjectsJob = new CheckProjectsToShare();

        public AutoShareProjects(IPreferencesService service) {
            super(service);
        }

        @Override
        public void stop() {
            boolean isRunning = !this.checkProjectsJob.cancel();
            Job.getJobManager().cancel(JobFamilies.AUTO_SHARE);
            try {
                if (isRunning) {
                    this.checkProjectsJob.join();
                }
                Job.getJobManager().join(JobFamilies.AUTO_SHARE, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException e) {
                Activator.logError(e.getLocalizedMessage(), e);
            }
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (!this.getBoolean("core_autoShareProjects", true)) {
                return;
            }
            try {
                final LinkedHashSet<IProject> projectCandidates = new LinkedHashSet<IProject>();
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        return this.collectOpenedProjects(delta, projectCandidates);
                    }
                });
                if (!projectCandidates.isEmpty()) {
                    this.checkProjectsJob.addProjectsToCheck(projectCandidates);
                }
            }
            catch (CoreException e) {
                Activator.logError(e.getMessage(), e);
                return;
            }
        }

        private boolean collectOpenedProjects(IResourceDelta delta, Set<IProject> projects) {
            if (delta.getKind() == 4 && (delta.getFlags() & INTERESTING_CHANGES) == 0) {
                return true;
            }
            IResource resource = delta.getResource();
            if (resource.getType() == 8) {
                return true;
            }
            if (resource.getType() != 4) {
                return false;
            }
            if (!resource.isAccessible() || resource.getLocation() == null) {
                return false;
            }
            projects.add((IProject)resource);
            return false;
        }
    }

    private static class CheckProjectsToShare
    extends Job {
        private Object lock = new Object();
        private Set<IProject> projectCandidates = new LinkedHashSet<IProject>();

        public CheckProjectsToShare() {
            super(CoreText.Activator_AutoShareJobName);
            this.setUser(false);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjectsToCheck(Set<IProject> projects) {
            Object object = this.lock;
            synchronized (object) {
                this.projectCandidates.addAll(projects);
                if (!this.projectCandidates.isEmpty()) {
                    this.schedule(100L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Set<IProject> projectsToCheck;
            Object object = this.lock;
            synchronized (object) {
                projectsToCheck = this.projectCandidates;
                this.projectCandidates = new LinkedHashSet<IProject>();
            }
            if (projectsToCheck.isEmpty()) {
                return Status.OK_STATUS;
            }
            HashMap<IProject, File> projects = new HashMap<IProject, File>();
            for (IProject project : projectsToCheck) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (!project.isAccessible()) continue;
                try {
                    this.visitConnect(project, projects);
                }
                catch (CoreException e) {
                    Activator.logError(e.getMessage(), e);
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (projects.size() > 0) {
                ConnectProviderOperation op = new ConnectProviderOperation(projects);
                op.setRefreshResources(false);
                JobUtil.scheduleUserJob(op, CoreText.Activator_AutoShareJobName, JobFamilies.AUTO_SHARE);
            }
            return Status.OK_STATUS;
        }

        private void visitConnect(IProject project, Map<IProject, File> projects) throws CoreException {
            if (RepositoryMapping.getMapping(project) != null) {
                return;
            }
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
            if (provider != null) {
                return;
            }
            RepositoryFinder f = new RepositoryFinder(project);
            f.setFindInChildren(false);
            List<RepositoryMapping> mappings = f.find((IProgressMonitor)new NullProgressMonitor());
            if (mappings.isEmpty()) {
                return;
            }
            RepositoryMapping m = mappings.get(0);
            IPath gitDirPath = m.getGitDirAbsolutePath();
            if (gitDirPath == null || !this.isValidRepositoryPath(gitDirPath)) {
                return;
            }
            File repositoryDir = gitDirPath.toFile();
            projects.put(project, repositoryDir);
            Set<String> configured = RepositoryUtil.INSTANCE.getRepositories();
            if (configured.contains(gitDirPath.toString())) {
                return;
            }
            int nofMappings = mappings.size();
            if (nofMappings > 1) {
                IPath lastPath = gitDirPath;
                int i = 1;
                while (i < nofMappings) {
                    IPath nextPath = mappings.get(i).getGitDirAbsolutePath();
                    if (nextPath != null) {
                        if (configured.contains(nextPath.toString())) {
                            return;
                        }
                        if (!this.isValidRepositoryPath(nextPath)) break;
                        lastPath = nextPath;
                    }
                    ++i;
                }
                repositoryDir = lastPath.toFile();
            }
            try {
                RepositoryUtil.INSTANCE.addConfiguredRepository(repositoryDir);
            }
            catch (IllegalArgumentException e) {
                Activator.logError(CoreText.Activator_AutoSharingFailed, e);
            }
        }

        private boolean isValidRepositoryPath(@NonNull IPath gitDirPath) {
            Path userHomePath;
            if (gitDirPath.segmentCount() == 0) {
                return false;
            }
            IPath workingDir = gitDirPath.removeLastSegments(1);
            if (workingDir.isRoot()) {
                return false;
            }
            File userHome = FS.DETECTED.userHome();
            return userHome == null || !workingDir.isPrefixOf((IPath)(userHomePath = new Path(userHome.getAbsolutePath())));
        }
    }

    private static class GitReleaseListener
    extends GitResourcChangeListener {
        public GitReleaseListener() {
            super(null);
        }

        @Override
        public void stop() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResource resource = event.getResource();
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                if (project.isAccessible()) {
                    IResource dotGit;
                    if (ResourceUtil.isSharedWithGit((IResource)project) && (dotGit = project.findMember(".git")) != null && dotGit.getType() == 2) {
                        RepositoryInitializer.reconfigureWindowCache();
                    }
                } else {
                    File locationDir;
                    File dotGit;
                    IPath locationPath = project.getLocation();
                    if (locationPath != null && (dotGit = new File(locationDir = locationPath.toFile(), ".git")).isDirectory()) {
                        RepositoryInitializer.reconfigureWindowCache();
                    }
                }
            }
        }
    }

    private static abstract class GitResourcChangeListener
    implements IResourceChangeListener {
        private final IPreferencesService preferencesService;

        protected GitResourcChangeListener(IPreferencesService service) {
            this.preferencesService = service;
        }

        protected boolean getBoolean(String pref, boolean defaultValue) {
            return this.preferencesService.getBoolean("org.eclipse.egit.core", pref, defaultValue, null);
        }

        public abstract void stop();
    }

    private static class IgnoreDerivedResources
    extends GitResourcChangeListener {
        public IgnoreDerivedResources(IPreferencesService service) {
            super(service);
        }

        @Override
        public void stop() {
            Job.getJobManager().cancel(JobFamilies.AUTO_IGNORE);
            try {
                Job.getJobManager().join(JobFamilies.AUTO_IGNORE, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException e) {
                Activator.logError(e.getLocalizedMessage(), e);
            }
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                IResourceDelta d = event.getDelta();
                if (d == null || !this.getBoolean("core_autoIgnoreDerivedResources", true)) {
                    return;
                }
                final LinkedHashSet<IPath> toBeIgnored = new LinkedHashSet<IPath>();
                d.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if ((delta.getKind() & 5) == 0) {
                            return false;
                        }
                        int flags = delta.getFlags();
                        if (flags != 0 && (flags & 0x400000) == 0) {
                            return false;
                        }
                        IResource r = delta.getResource();
                        if (r.getProject() != null && RepositoryMapping.getMapping(r) == null) {
                            return false;
                        }
                        if (r.isTeamPrivateMember()) {
                            return false;
                        }
                        if (r.isDerived()) {
                            try {
                                IPath location = r.getLocation();
                                if (RepositoryUtil.canBeAutoIgnored(location)) {
                                    toBeIgnored.add(location);
                                }
                            }
                            catch (IOException e) {
                                Activator.logError(MessageFormat.format(CoreText.Activator_ignoreResourceFailed, r.getFullPath()), e);
                            }
                            return false;
                        }
                        return true;
                    }
                });
                if (toBeIgnored.size() > 0) {
                    JobUtil.scheduleUserJob(new IgnoreOperation(toBeIgnored), CoreText.Activator_autoIgnoreDerivedResources, JobFamilies.AUTO_IGNORE);
                }
            }
            catch (CoreException e) {
                Activator.logError(e.getMessage(), e);
                return;
            }
        }
    }
}

