/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.gradle;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.workspace.CompositeModelQuery;
import org.eclipse.buildship.core.internal.workspace.TellGradleToRunAutoSyncTasks;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.gradle.api.Action;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.ProjectConnection;

public class IdeFriendlyClassLoading {
    private static URLClassLoader classLoader;

    private IdeFriendlyClassLoading() {
    }

    public static <T, U> BuildAction<Map<String, T>> loadCompositeModelQuery(Class<T> model, Class<U> parameterType, Action<? super U> parameter) {
        return (BuildAction)IdeFriendlyClassLoading.loadClass(CompositeModelQuery.class, model, parameterType, parameter);
    }

    public static <T> BuildAction<Map<String, T>> loadCompositeModelQuery(Class<T> model) {
        return (BuildAction)IdeFriendlyClassLoading.loadClass(CompositeModelQuery.class, model);
    }

    public static <T> T loadClass(Class<T> cls) {
        try {
            if (Platform.inDevelopmentMode()) {
                return (T)IdeFriendlyClassLoading.loadClassWithIdeFriendlyClassLoader(cls.getName()).newInstance();
            }
            return cls.newInstance();
        }
        catch (Exception e) {
            throw new GradlePluginsRuntimeException(e);
        }
    }

    public static <T> T loadClass(Class<T> cls, Object ... arguments) {
        try {
            Class<Object> theClass = Platform.inDevelopmentMode() ? IdeFriendlyClassLoading.loadClassWithIdeFriendlyClassLoader(cls.getName()) : cls;
            Class[] parameterTypes = new Class[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                parameterTypes[i] = arguments[i].getClass();
            }
            Constructor<T> constructor = IdeFriendlyClassLoading.findConstructor(theClass, arguments);
            return constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new GradlePluginsRuntimeException(e);
        }
    }

    private static <T> Constructor<T> findConstructor(Class<T> theClass, Object[] arguments) throws NoSuchMethodException {
        for (Constructor<?> c : theClass.getConstructors()) {
            if (c.getParameterCount() != arguments.length) continue;
            Parameter[] parameters = c.getParameters();
            boolean foundConstructor = true;
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].getType().isInstance(arguments[i])) continue;
                foundConstructor = false;
                break;
            }
            if (!foundConstructor) continue;
            return c;
        }
        throw new NoSuchMethodException("Failed fo find constructor on " + theClass.getName() + " accepting " + Arrays.asList(arguments));
    }

    public static void cleanup() {
        if (classLoader != null) {
            try {
                classLoader.close();
            }
            catch (IOException e) {
                throw new GradlePluginsRuntimeException(e);
            }
            classLoader = null;
        }
    }

    private static final Class<?> loadClassWithIdeFriendlyClassLoader(String classname) throws Exception {
        ClassLoader compatClassloader = TellGradleToRunAutoSyncTasks.class.getClassLoader();
        ClassLoader tapiClassloader = ProjectConnection.class.getClassLoader();
        URL actionRootUrl = FileLocator.resolve((URL)compatClassloader.getResource(""));
        if (classLoader == null) {
            classLoader = new URLClassLoader(new URL[]{actionRootUrl}, tapiClassloader);
        }
        return classLoader.loadClass(classname);
    }
}

