/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public abstract class AbstractPDEMarkerResolution
extends WorkbenchMarkerResolution {
    public static final int CREATE_TYPE = 1;
    public static final int RENAME_TYPE = 2;
    public static final int REMOVE_TYPE = 3;
    public static final int CONFIGURE_TYPE = 4;
    private Image image;
    protected int fType;
    protected IResource fResource;
    protected IMarker marker = null;

    public AbstractPDEMarkerResolution(int type) {
        this.fType = type;
    }

    public AbstractPDEMarkerResolution(int type, IMarker marker2) {
        this.fType = type;
        this.marker = marker2;
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        HashSet<IMarker> mset = new HashSet<IMarker>(markers.length);
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            String str;
            IMarker iMarker = iMarkerArray[n2];
            if (!iMarker.equals((Object)this.marker) && (str = iMarker.getAttribute("compilerKey", "")).equals(this.marker.getAttribute("compilerKey", ""))) {
                mset.add(iMarker);
            }
            ++n2;
        }
        int size = mset.size();
        return mset.toArray(new IMarker[size]);
    }

    public Image getImage() {
        if (this.image == null) {
            PDELabelProvider labelProvider = PDEPlugin.getDefault().getLabelProvider();
            this.image = switch (this.getType()) {
                case 1 -> labelProvider.get(PDEPluginImages.DESC_ADD_ATT);
                case 3 -> labelProvider.get(PDEPluginImages.DESC_DELETE);
                case 2 -> labelProvider.get(PDEPluginImages.DESC_REFRESH);
                case 4 -> labelProvider.get(PDEPluginImages.DESC_CON_SEV);
                default -> this.image;
            };
        }
        return this.image;
    }

    public int getType() {
        return this.fType;
    }

    public String getDescription() {
        return this.getLabel();
    }

    public void run(IMarker marker) {
        this.marker = marker;
        this.fResource = marker.getResource();
        ModelModification modification = new ModelModification((IFile)marker.getResource()){

            @Override
            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                AbstractPDEMarkerResolution.this.createChange(model);
            }
        };
        PDEModelUtility.modifyModel(modification, null);
    }

    protected abstract void createChange(IBaseModel var1);
}

