/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.feature;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.BundleProviderHistoryUtil;
import org.eclipse.pde.internal.ui.wizards.feature.AbstractFeatureSpecPage;
import org.eclipse.pde.internal.ui.wizards.feature.FeatureData;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FeatureSpecPage
extends AbstractFeatureSpecPage {
    private Combo fFeatureProviderCombo;
    private Text fFeatureIdText;

    public FeatureSpecPage() {
        this.setTitle(PDEUIMessages.NewFeatureWizard_SpecPage_title);
        this.setDescription(PDEUIMessages.NewFeatureWizard_SpecPage_desc);
    }

    @Override
    protected void initialize() {
        String projectName = this.getProjectName();
        if (this.fInitialId == null) {
            this.fFeatureIdText.setText(IdUtil.getValidId((String)projectName));
        }
        if (this.fInitialName == null) {
            this.fFeatureNameText.setText(projectName);
        }
        this.fFeatureVersionText.setText("1.0.0.qualifier");
        this.setMessage(PDEUIMessages.NewFeatureWizard_MainPage_desc);
    }

    @Override
    public FeatureData getFeatureData() {
        FeatureData data = new FeatureData();
        data.id = this.fFeatureIdText.getText();
        data.version = this.fFeatureVersionText.getText();
        data.provider = this.fFeatureProviderCombo.getText();
        data.name = this.fFeatureNameText.getText();
        data.library = this.getInstallHandlerLibrary();
        return data;
    }

    @Override
    protected String validateContent() {
        this.setMessage(null);
        return null;
    }

    @Override
    protected String getHelpId() {
        return "org.eclipse.pde.doc.user.new_feature_data";
    }

    @Override
    protected void createContents(Composite container) {
        Group group = new Group(container, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        gd.verticalIndent = 10;
        group.setLayoutData((Object)gd);
        group.setText(PDEUIMessages.BaseFeatureSpecPage_featurePropertiesGroup_title);
        Label label = new Label((Composite)group, 0);
        label.setText(PDEUIMessages.NewFeatureWizard_SpecPage_id);
        this.fFeatureIdText = new Text((Composite)group, 2048);
        this.fFeatureIdText.setLayoutData((Object)new GridData(768));
        this.createCommonInput((Composite)group);
        label = new Label((Composite)group, 0);
        label.setText(PDEUIMessages.NewFeatureWizard_SpecPage_provider);
        this.fFeatureProviderCombo = new Combo((Composite)group, 2052);
        this.fFeatureProviderCombo.setLayoutData((Object)new GridData(768));
        BundleProviderHistoryUtil.loadHistory(this.fFeatureProviderCombo, this.getDialogSettings());
        this.createInstallHandlerText((Composite)group);
    }

    @Override
    protected void attachListeners(ModifyListener listener) {
        this.fFeatureProviderCombo.addModifyListener(listener);
        this.fFeatureIdText.addModifyListener(listener);
    }

    @Override
    protected String getFeatureId() {
        return this.fFeatureIdText.getText();
    }

    @Override
    protected void updateNameRelativeFields() {
        if (this.fFeatureIdText == null || this.fFeatureNameText == null) {
            return;
        }
        this.fSelfModification = true;
        String id = IdUtil.getValidId((String)this.getProjectName());
        this.fFeatureIdText.setText(id);
        this.fFeatureNameText.setText(IdUtil.getValidName((String)id));
        if (this.fFeatureProviderCombo.getText().length() == 0) {
            this.fFeatureProviderCombo.setText(IdUtil.getValidProvider((String)id));
        }
        this.fSelfModification = false;
    }

    @Override
    protected void saveSettings(IDialogSettings settings) {
        BundleProviderHistoryUtil.saveHistory(this.fFeatureProviderCombo, settings);
    }
}

