/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringResourceSetProvider;

public class ElementRenameArguments {
    private final URI targetElementURI;
    private final Map<URI, URI> original2newElementURIs;
    private final IRenameStrategy renameStrategy;
    private final String newName;
    private final RefactoringResourceSetProvider resourceSetProvider;

    public ElementRenameArguments(URI targetElementURI, String newName, IRenameStrategy renameStrategy, Map<URI, URI> original2newElementURIs, RefactoringResourceSetProvider resourceSetProvider) {
        this.newName = newName;
        this.targetElementURI = targetElementURI;
        this.renameStrategy = renameStrategy;
        this.original2newElementURIs = original2newElementURIs;
        this.resourceSetProvider = resourceSetProvider;
    }

    public Iterable<URI> getRenamedElementURIs() {
        return this.original2newElementURIs.keySet();
    }

    public URI getTargetElementURI() {
        return this.targetElementURI;
    }

    public URI getNewElementURI(URI originalElementURI) {
        URI newElementURI = this.original2newElementURIs.get(originalElementURI);
        return newElementURI != null ? newElementURI : originalElementURI;
    }

    public IRenameStrategy getRenameStrategy() {
        return this.renameStrategy;
    }

    public String getNewName() {
        return this.newName;
    }

    public RefactoringResourceSetProvider getResourceSetProvider() {
        return this.resourceSetProvider;
    }
}

