/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.workspace;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.ui.workspace.EclipseProjectConfig;
import org.eclipse.xtext.ui.workspace.EclipseProjectConfigProvider;
import org.eclipse.xtext.workspace.IWorkspaceConfig;

public class EclipseWorkspaceConfig
implements IWorkspaceConfig {
    private final IWorkspaceRoot workspaceRoot;
    private final EclipseProjectConfigProvider projectConfigProvider;

    public EclipseWorkspaceConfig(IWorkspaceRoot workspaceRoot, EclipseProjectConfigProvider projectConfigProvider) {
        this.workspaceRoot = workspaceRoot;
        this.projectConfigProvider = projectConfigProvider;
    }

    public Set<? extends EclipseProjectConfig> getProjects() {
        return Arrays.asList(this.workspaceRoot.getProjects()).stream().filter(project -> project.isAccessible()).map(project -> this.projectConfigProvider.createProjectConfig(project.getProject())).collect(Collectors.toSet());
    }

    public EclipseProjectConfig findProjectByName(String name) {
        try {
            IProject project = this.workspaceRoot.getProject(name);
            if (project.isAccessible()) {
                return this.projectConfigProvider.createProjectConfig(project);
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public EclipseProjectConfig findProjectContaining(URI member) {
        if (member.isPlatformResource()) {
            return this.findProjectByName(URI.decode((String)member.segment(1)));
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.workspaceRoot == null ? 0 : this.workspaceRoot.hashCode());
        return prime * result + (this.projectConfigProvider == null ? 0 : this.projectConfigProvider.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EclipseWorkspaceConfig other = (EclipseWorkspaceConfig)obj;
        if (this.workspaceRoot == null ? other.workspaceRoot != null : !this.workspaceRoot.equals((Object)other.workspaceRoot)) {
            return false;
        }
        return !(this.projectConfigProvider == null ? other.projectConfigProvider != null : !this.projectConfigProvider.equals(other.projectConfigProvider));
    }

    public String toString() {
        return "workspaceRoot " + String.valueOf(this.workspaceRoot) + " projectConfigProvider " + String.valueOf(this.projectConfigProvider);
    }

    public IWorkspaceRoot getWorkspaceRoot() {
        return this.workspaceRoot;
    }

    public EclipseProjectConfigProvider getProjectConfigProvider() {
        return this.projectConfigProvider;
    }
}

