/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.eclipse.lemminx.NoOpInputStream;
import org.eclipse.lemminx.NoOpPrintStream;
import org.eclipse.lemminx.XMLLanguageServer;
import org.eclipse.lemminx.commons.ParentProcessWatcher;
import org.eclipse.lemminx.customservice.XMLLanguageClientAPI;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;

public class XMLServerLauncher {
    public static void main(String[] args) {
        boolean LEMMINX_DEBUG;
        String HTTP_PROXY_HOST = System.getenv("HTTP_PROXY_HOST");
        String HTTP_PROXY_PORT = System.getenv("HTTP_PROXY_PORT");
        String HTTP_PROXY_USERNAME = System.getenv("HTTP_PROXY_USERNAME");
        String HTTP_PROXY_PASSWORD = System.getenv("HTTP_PROXY_PASSWORD");
        boolean bl = LEMMINX_DEBUG = System.getenv("LEMMINX_DEBUG") != null;
        if (HTTP_PROXY_HOST != null && HTTP_PROXY_PORT != null) {
            System.setProperty("http.proxyHost", HTTP_PROXY_HOST);
            System.setProperty("http.proxyPort", HTTP_PROXY_PORT);
            System.setProperty("https.proxyHost", HTTP_PROXY_HOST);
            System.setProperty("https.proxyPort", HTTP_PROXY_PORT);
        }
        if (HTTP_PROXY_USERNAME != null && HTTP_PROXY_PASSWORD != null) {
            System.setProperty("http.proxyUser", HTTP_PROXY_USERNAME);
            System.setProperty("http.proxyPassword", HTTP_PROXY_PASSWORD);
        }
        final String username = System.getProperty("http.proxyUser");
        final String password = System.getProperty("http.proxyPassword");
        if (username != null && password != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            });
        }
        InputStream in = System.in;
        PrintStream out = System.out;
        System.setIn(new NoOpInputStream());
        System.setOut(new NoOpPrintStream());
        if (!LEMMINX_DEBUG) {
            System.setErr(new NoOpPrintStream());
        }
        XMLServerLauncher.launch(in, out);
    }

    public static Future<?> launch(InputStream in, OutputStream out) {
        XMLLanguageServer server = new XMLLanguageServer();
        ParentProcessWatcher wrapper = "false".equals(System.getProperty("watchParentProcess")) ? it -> it : new ParentProcessWatcher(server);
        Launcher<LanguageClient> launcher = XMLServerLauncher.createServerLauncher(server, in, out, Executors.newCachedThreadPool(), wrapper);
        server.setClient(launcher.getRemoteProxy());
        return launcher.startListening();
    }

    private static Launcher<LanguageClient> createServerLauncher(LanguageServer server, InputStream in, OutputStream out, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper) {
        return new LSPLauncher.Builder().setLocalService(server).setRemoteInterface(XMLLanguageClientAPI.class).setInput(in).setOutput(out).setExecutorService(executorService).wrapMessages(wrapper).create();
    }
}

