/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import java.util.Collection;
import org.eclipse.xtext.formatting2.debug.TextRegionsWithTitleToString;
import org.eclipse.xtext.formatting2.internal.RegionTrace;

public class ConflictingRegionsException
extends RuntimeException {
    private static final long serialVersionUID = 3957771424755606694L;
    private final Collection<RegionTrace> traces;

    public ConflictingRegionsException(String message, Collection<RegionTrace> traces) {
        this(message, null, traces);
    }

    public ConflictingRegionsException(String message, Throwable cause, Collection<RegionTrace> traces) {
        super(message, cause);
        this.traces = traces;
        for (RegionTrace trace : traces) {
            this.addSuppressed(trace);
        }
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.getMessage() + ".\n");
        TextRegionsWithTitleToString toStr = new TextRegionsWithTitleToString();
        for (RegionTrace trace : this.traces) {
            toStr.add(trace.getMessage(), trace.getRegion());
        }
        builder.append(toStr);
        return builder.toString();
    }

    public Collection<RegionTrace> getTraces() {
        return this.traces;
    }
}

