/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextSegment;
import org.eclipse.xtext.resource.XtextResource;

public class StringBasedRegionAccess
extends AbstractRegionAccess {
    private final Map<EObject, AbstractEObjectRegion> eObjectToTokens = Maps.newLinkedHashMap();
    private final XtextResource resource;
    private AbstractEObjectRegion root;
    private final StringBuilder string = new StringBuilder();

    protected StringBasedRegionAccess(XtextResource resource) {
        this.resource = resource;
    }

    protected void add(AbstractEObjectRegion tokens) {
        this.eObjectToTokens.put(tokens.getSemanticElement(), tokens);
    }

    protected int append(String value) {
        int length = this.string.length();
        this.string.append(value);
        return length;
    }

    @Override
    public XtextResource getResource() {
        return this.resource;
    }

    @Override
    protected String getText() {
        return this.string.toString();
    }

    @Override
    public ITextSegment regionForDocument() {
        return new TextSegment(this, 0, this.string.length());
    }

    @Override
    public AbstractEObjectRegion regionForEObject(EObject obj) {
        return this.eObjectToTokens.get(obj);
    }

    @Override
    public IEObjectRegion regionForRootEObject() {
        return this.root;
    }

    public void setRootEObject(AbstractEObjectRegion root) {
        this.root = root;
    }

    @Override
    public String textForOffset(int offset, int length) {
        return this.string.substring(offset, offset + length);
    }

    @Override
    public boolean hasSyntaxError() {
        return false;
    }
}

