/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.ui.internal.propertypage;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.wst.common.componentcore.ui.Messages;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.ResourceMappingFilterExtensionRegistry;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.IWizardHandle;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.WizardFragment;
import org.eclipse.wst.common.componentcore.ui.propertypage.AddModuleDependenciesPropertiesPage;

public class FolderMappingWizardFragment
extends WizardFragment {
    private IProject project;
    private TreeViewer viewer;
    private IContainer selected = null;
    protected IWizardHandle handle;
    boolean isComplete = false;

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public boolean hasComposite() {
        return true;
    }

    @Override
    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        handle.setTitle(Messages.AddFolder);
        handle.setDescription(Messages.AddFolderMappings);
        handle.setImageDescriptor(IDEWorkbenchPlugin.getIDEImageDescriptor((String)"wizban/newfolder_wiz.png"));
        this.project = (IProject)this.getTaskModel().getObject("root.project");
        Composite c = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        c.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)c, "org.eclipse.wst.common.modulecore.ui.DEPLOYMENT_ASSEMBLY_PREFERENCE_PAGE_ADD_NEW_FOLDER_MAPPING_P1");
        this.viewer = new TreeViewer(c, 2820);
        this.viewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.addFilter(this.getFilter());
        this.viewer.setInput((Object)this.project);
        this.viewer.addSelectionChangedListener(this.getListener());
        GridData data = new GridData(1808);
        data.widthHint = 390;
        data.heightHint = 185;
        this.viewer.getTree().setLayoutData((Object)data);
        return c;
    }

    protected ISelectionChangedListener getListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)FolderMappingWizardFragment.this.viewer.getSelection();
                Object first = sel.getFirstElement();
                if (first instanceof IContainer) {
                    FolderMappingWizardFragment.this.selected = (IContainer)first;
                    String errorMessage = FolderMappingWizardFragment.this.validateFolder();
                    if (errorMessage != null) {
                        FolderMappingWizardFragment.this.handle.setMessage(errorMessage, 3);
                    } else {
                        FolderMappingWizardFragment.this.handle.setMessage(Messages.AddFolderMappings, 0);
                    }
                    FolderMappingWizardFragment.this.handle.update();
                }
            }
        };
    }

    protected String validateFolder() {
        IContainer c = this.getSelected();
        IPath p = c.getProjectRelativePath().makeAbsolute();
        ArrayList currentRefs = (ArrayList)this.getTaskModel().getObject("all.directives");
        if (!currentRefs.isEmpty()) {
            int j = 0;
            while (j < currentRefs.size()) {
                Object ref = currentRefs.get(j);
                if (ref instanceof AddModuleDependenciesPropertiesPage.ComponentResourceProxy) {
                    AddModuleDependenciesPropertiesPage.ComponentResourceProxy folder = (AddModuleDependenciesPropertiesPage.ComponentResourceProxy)ref;
                    if (p.equals((Object)folder.source)) {
                        this.isComplete = false;
                        return NLS.bind((String)Messages.ExistingFolderError, (Object)folder.source);
                    }
                }
                ++j;
            }
        }
        this.isComplete = true;
        return null;
    }

    public IContainer getSelected() {
        return this.selected;
    }

    protected ViewerFilter getFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IContainer container;
                IPath path;
                return element instanceof IContainer && !ResourceMappingFilterExtensionRegistry.shouldFilter(path = (container = (IContainer)element).getProjectRelativePath());
            }
        };
    }

    protected ITreeContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                try {
                    return FolderMappingWizardFragment.this.project.members();
                }
                catch (CoreException coreException) {
                    return new Object[0];
                }
            }

            public boolean hasChildren(Object element) {
                if (element instanceof IContainer) {
                    try {
                        return ((IContainer)element).members().length > 0;
                    }
                    catch (CoreException coreException) {}
                }
                return false;
            }

            public Object getParent(Object element) {
                if (element instanceof IResource) {
                    return ((IResource)element).getParent();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IContainer) {
                    try {
                        return ((IContainer)parentElement).members();
                    }
                    catch (CoreException coreException) {}
                }
                return new Object[0];
            }
        };
    }

    protected LabelProvider getLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }

            public String getText(Object element) {
                if (element instanceof IResource) {
                    return ((IResource)element).getName();
                }
                return element.toString();
            }
        };
    }

    @Override
    public void performFinish(IProgressMonitor monitor) throws CoreException {
        IContainer c = this.getSelected();
        if (c != null) {
            IPath p = c.getProjectRelativePath().makeAbsolute();
            AddModuleDependenciesPropertiesPage.ComponentResourceProxy proxy = new AddModuleDependenciesPropertiesPage.ComponentResourceProxy(p, (IPath)new Path("/"));
            this.getTaskModel().putObject("folder.mapping", proxy);
        }
    }
}

