/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.pom;

import org.eclipse.jface.action.ControlContribution;
import org.eclipse.m2e.editor.MavenEditorImages;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SearchControl
extends ControlContribution {
    private final IManagedForm managedForm;
    Text searchText;

    public SearchControl(String id, IManagedForm managedForm) {
        super(id);
        this.managedForm = managedForm;
    }

    public Text getSearchText() {
        return this.searchText;
    }

    private boolean isMac() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Mac");
    }

    protected Control createControl(Composite parent) {
        if (parent instanceof ToolBar) {
            parent.setCursor(null);
        }
        FormToolkit toolkit = this.managedForm.getToolkit();
        Composite composite = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = this.isMac() ? -1 : 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setBackground(null);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label = toolkit.createLabel(composite, Messages.SearchControl_lblSearch);
        label.setBackground(null);
        this.searchText = toolkit.createText(composite, "", 0x800080);
        this.searchText.setData("textBorder", (Object)Boolean.TRUE);
        this.searchText.setLayoutData((Object)new GridData(200, -1));
        ToolBar cancelBar = new ToolBar(composite, 0x800000);
        ToolItem clearToolItem = new ToolItem(cancelBar, 0);
        clearToolItem.setEnabled(false);
        clearToolItem.setImage(MavenEditorImages.IMG_CLEAR);
        clearToolItem.setDisabledImage(MavenEditorImages.IMG_CLEAR_DISABLED);
        clearToolItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.searchText.setText("")));
        this.searchText.addModifyListener(e -> clearToolItem.setEnabled(this.searchText.getText().length() > 0));
        toolkit.paintBordersFor(composite);
        return composite;
    }
}

