/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.declaration;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Modifier;

public abstract class DeclarationImpl
extends EclipseDeclarationImpl {
    protected final IBinding _binding;

    DeclarationImpl(IBinding binding, BaseProcessorEnv env) {
        super(env);
        assert (binding != null) : "binding cannot be null";
        this._binding = binding;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DeclarationImpl) {
            return this._binding.isEqualTo(((DeclarationImpl)obj)._binding);
        }
        return false;
    }

    public int hashCode() {
        String key = this.getDeclarationBinding().getKey();
        return key == null ? 0 : key.hashCode();
    }

    public abstract IBinding getDeclarationBinding();

    @Override
    public Collection<com.sun.mirror.declaration.Modifier> getModifiers() {
        int modBits = this.getDeclarationBinding().getModifiers();
        ArrayList<com.sun.mirror.declaration.Modifier> mods = new ArrayList<com.sun.mirror.declaration.Modifier>(4);
        if (Modifier.isAbstract((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.ABSTRACT);
        }
        if (Modifier.isFinal((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.FINAL);
        }
        if (Modifier.isNative((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.NATIVE);
        }
        if (Modifier.isPrivate((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.PRIVATE);
        }
        if (Modifier.isProtected((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.PROTECTED);
        }
        if (Modifier.isPublic((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.PUBLIC);
        }
        if (Modifier.isStatic((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.STATIC);
        }
        if (Modifier.isStrictfp((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.STRICTFP);
        }
        if (Modifier.isSynchronized((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.SYNCHRONIZED);
        }
        if (Modifier.isTransient((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.TRANSIENT);
        }
        if (Modifier.isVolatile((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.VOLATILE);
        }
        return mods;
    }

    @Override
    public boolean isBindingBased() {
        return true;
    }

    @Override
    ASTNode getAstNode() {
        if (!this.isFromSource()) {
            return null;
        }
        return this._env.getASTNodeForBinding(this.getDeclarationBinding());
    }

    @Override
    CompilationUnit getCompilationUnit() {
        if (!this.isFromSource()) {
            return null;
        }
        return this._env.getCompilationUnitForBinding(this.getDeclarationBinding());
    }

    @Override
    public IFile getResource() {
        if (this.isFromSource()) {
            IBinding binding = this.getDeclarationBinding();
            return this._env.getDeclaringFileForBinding(binding);
        }
        return null;
    }
}

