/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.util;

import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.util.Declarations;
import org.eclipse.jdt.apt.core.internal.NonEclipseImplementationException;
import org.eclipse.jdt.apt.core.internal.declaration.DeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.MemberDeclarationImpl;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;

public class DeclarationsUtil
implements Declarations {
    @Override
    public boolean hides(MemberDeclaration sub, MemberDeclaration sup) {
        int supKind;
        if (sub == sup || sub.equals(sup)) {
            return false;
        }
        if (!((EclipseDeclarationImpl)((Object)sub)).isBindingBased() || !((EclipseDeclarationImpl)((Object)sup)).isBindingBased()) {
            return false;
        }
        MemberDeclarationImpl subImpl = (MemberDeclarationImpl)sub;
        MemberDeclarationImpl supImpl = (MemberDeclarationImpl)sup;
        IBinding subBinding = subImpl.getDeclarationBinding();
        IBinding supBinding = supImpl.getDeclarationBinding();
        int subKind = subBinding.getKind();
        if (subKind != (supKind = supBinding.getKind()) || subKind == 1) {
            return false;
        }
        if (!subBinding.getName().equals(supBinding.getName())) {
            return false;
        }
        if (subKind == 4) {
            IMethodBinding methodBinding;
            boolean allowed = false;
            int modifiers = subBinding.getModifiers();
            if ((modifiers & 8) == 8 && (methodBinding = (IMethodBinding)subBinding).isSubsignature((IMethodBinding)supBinding)) {
                allowed = true;
            }
            if (!allowed) {
                return false;
            }
        }
        ITypeBinding subClass = DeclarationsUtil.getDeclaringClass(subBinding);
        ITypeBinding supClass = DeclarationsUtil.getDeclaringClass(supBinding);
        if (subClass == null || supClass == null) {
            return false;
        }
        if (!subClass.isSubTypeCompatible(supClass)) {
            return false;
        }
        return DeclarationsUtil.isVisibleForHiding(supClass, supClass, supBinding.getModifiers());
    }

    private static boolean isVisibleForHiding(ITypeBinding declaringTarget, ITypeBinding declaringViewer, int modifiers) {
        if ((modifiers & 1) == 1) {
            return true;
        }
        if ((modifiers & 2) == 2) {
            return declaringTarget.equals((Object)declaringViewer);
        }
        if ((modifiers & 4) == 4) {
            return true;
        }
        IPackageBinding targetPackage = declaringTarget.getPackage();
        IPackageBinding viewerPackage = declaringViewer.getPackage();
        return targetPackage.equals((Object)viewerPackage);
    }

    @Override
    public boolean overrides(MethodDeclaration sub, MethodDeclaration sup) {
        IMethodBinding subBinding = (IMethodBinding)DeclarationsUtil.getBinding(sub);
        IMethodBinding supBinding = (IMethodBinding)DeclarationsUtil.getBinding(sup);
        if (subBinding == null || supBinding == null) {
            return false;
        }
        return subBinding.overrides(supBinding);
    }

    private static IBinding getBinding(MemberDeclaration memberDecl) throws NonEclipseImplementationException {
        if (memberDecl == null) {
            return null;
        }
        if (memberDecl instanceof EclipseMirrorObject) {
            if (memberDecl instanceof DeclarationImpl) {
                return ((DeclarationImpl)((Object)memberDecl)).getDeclarationBinding();
            }
            return null;
        }
        throw new NonEclipseImplementationException("only applicable to eclipse type system objects. Found " + memberDecl.getClass().getName());
    }

    private static ITypeBinding getDeclaringClass(IBinding binding) {
        int kind = binding.getKind();
        if (kind == 2) {
            return ((ITypeBinding)binding).getDeclaringClass();
        }
        if (kind == 4) {
            return ((IMethodBinding)binding).getDeclaringClass();
        }
        if (kind == 3) {
            return ((IVariableBinding)binding).getDeclaringClass();
        }
        return null;
    }
}

