/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

public class Throttler {
    private final Runnable timerExec;
    private final Display display;
    private final AtomicBoolean scheduled = new AtomicBoolean();
    private volatile long lastRunFinishedNanos;

    public Throttler(Display display, Duration minWaitTime, Runnable runnable) {
        Objects.requireNonNull(runnable);
        Objects.requireNonNull(display);
        this.display = display;
        if (minWaitTime.isNegative()) {
            throw new IllegalArgumentException("Minimum wait time must be positive");
        }
        if (minWaitTime.toMillis() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Minimum wait time in millis must be smaller than 2147483647");
        }
        int minWaitBetweenRunMillis = (int)minWaitTime.toMillis();
        Runnable runner = () -> {
            this.scheduled.set(false);
            runnable.run();
            long nanoTime = System.nanoTime();
            if (nanoTime == 0L) {
                nanoTime = -1L;
            }
            this.lastRunFinishedNanos = nanoTime;
        };
        this.timerExec = () -> {
            long elapsedNanos = System.nanoTime() - this.lastRunFinishedNanos;
            long elapsedMillis = elapsedNanos / 1000000L;
            if (this.lastRunFinishedNanos == 0L || elapsedMillis > (long)minWaitBetweenRunMillis) {
                runner.run();
            } else if (!display.isDisposed()) {
                long millisDifference = (long)minWaitBetweenRunMillis - elapsedMillis;
                int millisToWait = Math.max((int)millisDifference, 0);
                display.timerExec(millisToWait, runner);
            } else {
                this.scheduled.set(false);
            }
        };
    }

    public void throttledExec() {
        this.throttledExec(true);
    }

    public void throttledAsyncExec() {
        this.throttledExec(false);
    }

    private void throttledExec(boolean allowSyncExec) {
        if (this.display.isDisposed()) {
            return;
        }
        if (this.scheduled.compareAndSet(false, true)) {
            boolean exception = true;
            try {
                try {
                    if (allowSyncExec && Thread.currentThread() == this.display.getThread()) {
                        this.timerExec.run();
                    } else {
                        this.display.asyncExec(this.timerExec);
                    }
                    exception = false;
                }
                catch (SWTException e) {
                    if (!this.display.isDisposed()) {
                        throw e;
                    }
                    if (exception) {
                        this.scheduled.set(false);
                    }
                }
            }
            finally {
                if (exception) {
                    this.scheduled.set(false);
                }
            }
        }
    }
}

