/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.swt.graphics.Image;

public class MavenVersionDecorator
implements ILabelDecorator {
    private final Map<ILabelProviderListener, IMavenProjectChangedListener> listeners = new HashMap<ILabelProviderListener, IMavenProjectChangedListener>();

    public Image decorateImage(Image image, Object element) {
        return null;
    }

    public String decorateText(String text, Object element) {
        ArtifactKey mavenProject;
        IMavenProjectRegistry projectManager;
        IMavenProjectFacade facade;
        IResource resource;
        IProject project;
        if (element instanceof IResource && (project = (resource = (IResource)element).getProject()) != null && (facade = (projectManager = MavenPlugin.getMavenProjectRegistry()).create(project, (IProgressMonitor)new NullProgressMonitor())) != null && (mavenProject = facade.getArtifactKey()) != null) {
            int n;
            String name = resource.getName();
            int start = text.indexOf(name);
            if (start > -1 && (n = text.indexOf(32, start + name.length())) > -1) {
                return text.substring(0, n) + "  " + mavenProject.version() + text.substring(n);
            }
            return text + "  " + mavenProject.version();
        }
        return null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
        IMavenProjectChangedListener projectChangeListener = (events, monitor) -> {
            ArrayList<Object> pomList = new ArrayList<Object>();
            for (MavenProjectChangedEvent event : events) {
                if (event == null || event.getMavenProject() == null) continue;
                IFile pom = event.getMavenProject().getPom();
                pomList.add(pom);
                if (pom.getParent().getType() != 4) continue;
                pomList.add(pom.getParent());
            }
            listener.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, pomList.toArray()));
        };
        this.listeners.put(listener, projectChangeListener);
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        projectManager.addMavenProjectChangedListener(projectChangeListener);
    }

    public void removeListener(ILabelProviderListener listener) {
        IMavenProjectChangedListener projectChangeListener = this.listeners.get(listener);
        if (projectChangeListener != null) {
            IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
            projectManager.removeMavenProjectChangedListener(projectChangeListener);
        }
    }

    public void dispose() {
    }
}

