/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.editing;

import org.apache.maven.model.Dependency;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.editing.PomHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddExclusionOperation
implements PomEdits.Operation {
    private static final Logger log = LoggerFactory.getLogger(AddExclusionOperation.class);
    private final Dependency dependency;
    private final ArtifactKey exclusion;

    public AddExclusionOperation(Dependency dependency, ArtifactKey exclusion) {
        this.dependency = dependency;
        this.exclusion = exclusion;
    }

    @Override
    public void process(Document document) {
        Element depElement = PomHelper.findDependency(document, this.dependency);
        if (depElement != null) {
            Element exclusionsElement = PomEdits.getChild(depElement, "exclusions");
            if (PomEdits.findChild(exclusionsElement, "exclusion", PomEdits.childEquals("groupId", this.exclusion.groupId()), PomEdits.childEquals("artifactId", this.exclusion.artifactId())) == null) {
                Element exclusionElement = PomEdits.createElement(exclusionsElement, "exclusion");
                PomEdits.createElementWithText(exclusionElement, "groupId", this.exclusion.groupId());
                PomEdits.createElementWithText(exclusionElement, "artifactId", this.exclusion.artifactId());
                PomEdits.format(exclusionElement);
            }
        } else {
            log.debug("Dependency " + String.valueOf(this.dependency) + " is not present for exclusion " + this.exclusion.toString());
        }
    }
}

