/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.preferences;

import java.io.File;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleMappingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger log = LoggerFactory.getLogger(LifecycleMappingPreferencePage.class);
    private String mappingFilePath;
    private PluginExecutionAction mojoAction;
    private Text mappingFileTextBox;
    private ComboViewer mojoExecutionComboViewer;

    public LifecycleMappingPreferencePage() {
        this.setMessage(Messages.LifecycleMappingPreferencePage_this_message);
        this.setTitle(Messages.LifecycleMappingPreferencePage_LifecycleMapping);
    }

    protected void performDefaults() {
        this.mappingFilePath = this.getDefaultLocation();
        this.mojoAction = PluginExecutionAction.DEFAULT_ACTION;
        this.mojoExecutionComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.mojoAction));
        this.mappingFileTextBox.setText(this.mappingFilePath);
        super.performDefaults();
    }

    public boolean performOk() {
        try {
            IMavenConfiguration configuration = MavenPlugin.getMavenConfiguration();
            configuration.setDefaultMojoExecutionAction(this.mojoAction);
            configuration.setWorkspaceLifecycleMappingMetadataFile(this.mappingFilePath);
            LifecycleMappingFactory.getWorkspaceMetadata((boolean)true);
            return super.performOk();
        }
        catch (CoreException ex) {
            this.setErrorMessage(ex.getStatus().getMessage());
            return false;
        }
    }

    public void init(IWorkbench workbench) {
        this.mappingFilePath = this.getCurrentLocation();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        new Label(composite, 64).setText(Messages.LifecycleMappingPreferencePage_WorkspaceMappingsDescription);
        Button editLifecyclesButton = new Button(composite, 8);
        editLifecyclesButton.setText(Messages.LifecycleMappingPreferencePage_WorkspaceMappingsOpen);
        editLifecyclesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            try {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchPage workbenchPage = workbench.getActiveWorkbenchWindow().getActivePage();
                IEditorDescriptor desc = workbench.getEditorRegistry().getDefaultEditor("lifecycle-mapping-metadata.xml");
                FileStoreEditorInput input = new FileStoreEditorInput(EFS.getLocalFileSystem().fromLocalFile(new File(this.mappingFilePath)));
                IDE.openEditor((IWorkbenchPage)workbenchPage, (IEditorInput)input, (String)desc.getId());
            }
            catch (PartInitException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }));
        Button refreshLifecyclesButton = new Button(composite, 0);
        refreshLifecyclesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            LifecycleMappingMetadataSource lifecycleMappingMetadataSource = LifecycleMappingFactory.getWorkspaceMetadata((boolean)true);
        }));
        refreshLifecyclesButton.setText(Messages.LifecycleMappingPreferencePage_btnRefreshLifecycles_text);
        new Label(composite, 0).setText(Messages.LifecycleMappingPreferencePage_ChangeLocation);
        this.mappingFileTextBox = new Text(composite, 2048);
        this.mappingFileTextBox.setText(this.getCurrentLocation());
        this.mappingFileTextBox.addModifyListener(e -> {
            String string = this.mappingFilePath = this.mappingFileTextBox.getText();
        });
        Button newFileButton = new Button(composite, 8);
        newFileButton.setText(Messages.LifecycleMappingPreferencePage_Browse);
        newFileButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog dialog = new FileDialog(this.getShell(), 0);
            dialog.setText(Messages.LifecycleMappingPreferencePage_ChooseNewLocation);
            dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
            String res = dialog.open();
            if (res == null) {
                return;
            }
            this.mappingFileTextBox.setText(dialog.getFilterPath() + "/" + dialog.getFileName());
        }));
        Composite mojoExeSettings = new Composite(composite, 0);
        mojoExeSettings.setLayout((Layout)new GridLayout(2, false));
        new Label(mojoExeSettings, 0).setText(Messages.LifecycleMappingPreferencePage_DefaultMojoExecution);
        this.mojoExecutionComboViewer = new ComboViewer(mojoExeSettings);
        this.mojoExecutionComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.mojoExecutionComboViewer.setInput(List.of(PluginExecutionAction.execute, PluginExecutionAction.ignore, PluginExecutionAction.warn, PluginExecutionAction.error));
        this.mojoAction = MavenPlugin.getMavenConfiguration().getDefaultMojoExecutionAction();
        this.mojoExecutionComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.mojoAction));
        this.mojoExecutionComboViewer.addSelectionChangedListener(e -> {
            this.mojoAction = (PluginExecutionAction)e.getStructuredSelection().getFirstElement();
        });
        return composite;
    }

    private String getCurrentLocation() {
        return MavenPlugin.getMavenConfiguration().getWorkspaceLifecycleMappingMetadataFile();
    }

    private String getDefaultLocation() {
        IPath stateLocation = MavenPluginActivator.getDefault().getStateLocation();
        return stateLocation.append("lifecycle-mapping-metadata.xml").toString();
    }
}

