/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.internal.emulator;

import java.io.PrintStream;
import org.eclipse.terminal.internal.emulator.IVT100EmulatorBackend;
import org.eclipse.terminal.model.TerminalStyle;

public class VT100BackendTraceDecorator
implements IVT100EmulatorBackend {
    final IVT100EmulatorBackend fBackend;
    final PrintStream fWriter;

    public VT100BackendTraceDecorator(IVT100EmulatorBackend backend, PrintStream out) {
        this.fBackend = backend;
        this.fWriter = out;
    }

    @Override
    public void appendString(String buffer) {
        this.fWriter.println("appendString(\"" + buffer + "\")");
        this.fBackend.appendString(buffer);
    }

    @Override
    public void clearAll() {
        this.fWriter.println("clearAll()");
        this.fBackend.clearAll();
    }

    @Override
    public void deleteCharacters(int n) {
        this.fWriter.println("deleteCharacters(" + n + ")");
        this.fBackend.deleteCharacters(n);
    }

    @Override
    public void deleteLines(int n) {
        this.fWriter.println("deleteLines(" + n + ")");
        this.fBackend.deleteLines(n);
    }

    @Override
    public void eraseAll() {
        this.fWriter.println("eraseAll()");
        this.fBackend.eraseAll();
    }

    @Override
    public void eraseLine() {
        this.fWriter.println("eraseLine()");
        this.fBackend.eraseLine();
    }

    @Override
    public void eraseLineToCursor() {
        this.fWriter.println("eraseLineToCursor()");
        this.fBackend.eraseLineToCursor();
    }

    @Override
    public void eraseLineToEnd() {
        this.fWriter.println("eraseLineToEnd()");
        this.fBackend.eraseLineToEnd();
    }

    @Override
    public void eraseToCursor() {
        this.fWriter.println("eraseToCursor()");
        this.fBackend.eraseToCursor();
    }

    @Override
    public void eraseToEndOfScreen() {
        this.fWriter.println("eraseToEndOfScreen()");
        this.fBackend.eraseToEndOfScreen();
    }

    @Override
    public int getColumns() {
        return this.fBackend.getColumns();
    }

    @Override
    public int getCursorColumn() {
        return this.fBackend.getCursorColumn();
    }

    @Override
    public int getCursorLine() {
        return this.fBackend.getCursorLine();
    }

    @Override
    public TerminalStyle getDefaultStyle() {
        return this.fBackend.getDefaultStyle();
    }

    @Override
    public int getLines() {
        return this.fBackend.getLines();
    }

    @Override
    public TerminalStyle getStyle() {
        return this.fBackend.getStyle();
    }

    @Override
    public void insertCharacters(int charactersToInsert) {
        this.fWriter.println("insertCharacters(" + charactersToInsert + ")");
        this.fBackend.insertCharacters(charactersToInsert);
    }

    @Override
    public void insertLines(int n) {
        this.fWriter.println("insertLines(" + n + ")");
        this.fBackend.insertLines(n);
    }

    @Override
    public void processNewline() {
        this.fWriter.println("processNewline()");
        this.fBackend.processNewline();
    }

    @Override
    public void setCursor(int targetLine, int targetColumn) {
        this.fWriter.println("setCursor(" + targetLine + ", " + targetColumn + ")");
        this.fBackend.setCursor(targetLine, targetColumn);
    }

    @Override
    public void setCursorColumn(int targetColumn) {
        this.fWriter.println("setCursorColumn(" + targetColumn + ")");
        this.fBackend.setCursorColumn(targetColumn);
    }

    @Override
    public void setCursorLine(int targetLine) {
        this.fWriter.println("setCursorLine(" + targetLine + ")");
        this.fBackend.setCursorLine(targetLine);
    }

    @Override
    public void setDefaultStyle(TerminalStyle defaultStyle) {
        this.fWriter.println("setDefaultStyle(" + String.valueOf(defaultStyle) + ")");
        this.fBackend.setDefaultStyle(defaultStyle);
    }

    @Override
    public void setDimensions(int lines, int cols) {
        this.fWriter.println("setDimensions(" + lines + "," + cols + ")");
        this.fBackend.setDimensions(lines, cols);
    }

    @Override
    public void setStyle(TerminalStyle style) {
        this.fWriter.println("setStyle(" + String.valueOf(style) + ")");
        this.fBackend.setStyle(style);
    }

    @Override
    public void setVT100LineWrapping(boolean enable) {
        this.fWriter.println("setVT100LineWrapping(" + enable + ")");
        this.fBackend.setVT100LineWrapping(enable);
    }

    @Override
    public boolean isVT100LineWrapping() {
        return this.fBackend.isVT100LineWrapping();
    }

    @Override
    public void setInsertMode(boolean enable) {
        this.fWriter.println("setInsertMode(" + enable + ")");
        this.fBackend.setInsertMode(enable);
    }

    @Override
    public void setScrollRegion(int top, int bottom) {
        this.fWriter.println("setScrollRegion(" + top + "," + bottom + ")");
        this.fBackend.setScrollRegion(top, bottom);
    }

    @Override
    public void scrollUp(int lines) {
        this.fWriter.println("scrollUp(" + lines + ")");
        this.fBackend.scrollUp(lines);
    }

    @Override
    public void scrollDown(int lines) {
        this.fWriter.println("scrollDown(" + lines + ")");
        this.fBackend.scrollDown(lines);
    }

    @Override
    public void processReverseLineFeed() {
        this.fWriter.println("processReverseLineFeed()");
        this.fBackend.processReverseLineFeed();
    }

    @Override
    public void eraseCharacters(int n) {
        this.fWriter.println("eraseCharacters(" + n + ")");
        this.fBackend.eraseCharacters(n);
    }
}

