/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.compare.ICompareNavigator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;

public class NavigateAction
extends Action {
    private final boolean next;
    private final ISynchronizePageConfiguration configuration;

    public NavigateAction(ISynchronizePageConfiguration configuration, boolean next) {
        this.configuration = configuration;
        this.next = next;
        IActionBars bars = configuration.getSite().getActionBars();
        if (next) {
            Utils.initAction((IAction)this, "action.navigateNext.");
            this.setActionDefinitionId(ActionFactory.NEXT.getCommandId());
            if (bars != null) {
                bars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this);
            }
        } else {
            Utils.initAction((IAction)this, "action.navigatePrevious.");
            this.setActionDefinitionId(ActionFactory.PREVIOUS.getCommandId());
            if (bars != null) {
                bars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this);
            }
        }
    }

    public void run() {
        ICompareNavigator nav = (ICompareNavigator)this.configuration.getProperty("org.eclipse.team.ui.P_NAVIGATOR");
        nav.selectChange(this.next);
    }
}

