/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.ui.TeamImages;

public abstract class ParticipantSynchronizeWizard
extends Wizard {
    private WizardPage selectionPage;
    private IWizard importWizard;

    protected ParticipantSynchronizeWizard() {
        this.setDefaultPageImageDescriptor(TeamImages.getImageDescriptor("wizban/share_wizban.svg"));
        this.setNeedsProgressMonitor(false);
    }

    public String getWindowTitle() {
        return TeamUIMessages.GlobalRefreshSubscriberPage_0;
    }

    public void addPages() {
        if (this.getRootResources().length == 0) {
            this.importWizard = this.getImportWizard();
            if (this.importWizard != null) {
                this.importWizard.setContainer(this.getContainer());
                this.importWizard.addPages();
                IWizardPage startingPage = this.importWizard.getStartingPage();
                if (startingPage != null) {
                    startingPage.setTitle(NLS.bind((String)TeamUIMessages.SubscriberParticipantWizard_0, (Object)this.getPageTitle()));
                    startingPage.setDescription(NLS.bind((String)TeamUIMessages.SubscriberParticipantWizard_1, (Object)this.importWizard.getWindowTitle()));
                }
            }
        } else {
            this.selectionPage = this.createScopeSelectionPage();
            this.selectionPage.setTitle(NLS.bind((String)TeamUIMessages.GlobalRefreshSubscriberPage_1, (Object)this.getPageTitle()));
            this.selectionPage.setMessage(TeamUIMessages.GlobalRefreshSubscriberPage_2);
            this.addPage((IWizardPage)this.selectionPage);
        }
    }

    public boolean performFinish() {
        if (this.importWizard != null) {
            return this.importWizard.performFinish();
        }
        this.createParticipant();
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.importWizard != null) {
            return this.importWizard.getNextPage(page);
        }
        return super.getNextPage(page);
    }

    public boolean performCancel() {
        if (this.importWizard != null) {
            return this.importWizard.performCancel();
        }
        return super.performCancel();
    }

    public boolean canFinish() {
        if (this.importWizard != null) {
            return this.importWizard.canFinish();
        }
        return super.canFinish();
    }

    public IWizardPage getStartingPage() {
        if (this.importWizard != null) {
            return this.importWizard.getStartingPage();
        }
        return super.getStartingPage();
    }

    protected abstract String getPageTitle();

    protected abstract IWizard getImportWizard();

    protected abstract IResource[] getRootResources();

    protected abstract WizardPage createScopeSelectionPage();

    protected abstract void createParticipant();
}

