/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adapters;

import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.design.IAnnotationProvider;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDParticle;

public class XSDParticleAdapter
extends XSDBaseAdapter
implements IAnnotationProvider {
    public int getMaxOccurs() {
        return XSDParticleAdapter.getMaxOccurs((XSDConcreteComponent)this.target);
    }

    public int getMinOccurs() {
        return XSDParticleAdapter.getMinOccurs((XSDConcreteComponent)this.target);
    }

    public static int getMinOccurs(XSDConcreteComponent component) {
        XSDConcreteComponent o;
        int minOccur = -2;
        if (component != null && (o = component.getContainer()) instanceof XSDParticle && ((XSDParticle)o).isSetMinOccurs()) {
            try {
                minOccur = ((XSDParticle)o).getMinOccurs();
            }
            catch (Exception exception) {}
        }
        return minOccur;
    }

    public static int getMaxOccurs(XSDConcreteComponent component) {
        XSDConcreteComponent o;
        int maxOccur = -2;
        if (component != null && (o = component.getContainer()) instanceof XSDParticle && ((XSDParticle)o).isSetMaxOccurs()) {
            try {
                maxOccur = ((XSDParticle)o).getMaxOccurs();
            }
            catch (Exception exception) {}
        }
        return maxOccur;
    }

    public String getNameAnnotationString() {
        return this.buildAnnotationString(true);
    }

    public String getNameAnnotationToolTipString() {
        return this.buildAnnotationString(false);
    }

    public String getTypeAnnotationString() {
        return null;
    }

    public String getTypeAnnotationToolTipString() {
        return null;
    }

    protected String buildAnnotationString(boolean isForLabel) {
        String occurenceDescription = "";
        String toolTipDescription = "";
        int minOccurs = this.getMinOccurs();
        int maxOccurs = this.getMaxOccurs();
        if (minOccurs == -3 && maxOccurs == -3) {
            occurenceDescription = "";
        } else if (minOccurs == 0 && (maxOccurs == -2 || maxOccurs == 1)) {
            occurenceDescription = "[0..1]";
            toolTipDescription = Messages._UI_LABEL_OPTIONAL;
        } else if (minOccurs == 0 && maxOccurs == -1) {
            occurenceDescription = "[0..*]";
            toolTipDescription = Messages._UI_LABEL_ZERO_OR_MORE;
        } else if (minOccurs == 1 && maxOccurs == -1 || minOccurs == -2 && maxOccurs == -1) {
            occurenceDescription = "[1..*]";
            toolTipDescription = Messages._UI_LABEL_ONE_OR_MORE;
        } else if (minOccurs == 1 && maxOccurs == 1 || minOccurs == -2 && maxOccurs == 1 || minOccurs == 1 && maxOccurs == -2) {
            occurenceDescription = "[1..1]";
            toolTipDescription = Messages._UI_LABEL_REQUIRED;
        } else if (minOccurs == -2 && maxOccurs == -2) {
            occurenceDescription = "";
        } else {
            if (maxOccurs == -2) {
                maxOccurs = 1;
            }
            String maxSymbol = maxOccurs == -1 ? "*" : "" + maxOccurs;
            String minSymbol = minOccurs == -2 ? "1" : "" + minOccurs;
            occurenceDescription = "[" + minSymbol + ".." + maxSymbol + "]";
            toolTipDescription = Messages._UI_LABEL_ARRAY;
        }
        if (isForLabel) {
            return occurenceDescription;
        }
        return toolTipDescription;
    }
}

