/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.editor;

import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.NamedNodeMap;

public abstract class BaseHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        int offset;
        if (region == null || textViewer == null) {
            return null;
        }
        ArrayList<IHyperlink> hyperlinks = new ArrayList<IHyperlink>(0);
        IDocument document = textViewer.getDocument();
        IDOMNode node = this.getCurrentNode(document, offset = region.getOffset());
        if (!this.isLinkable(node)) {
            return null;
        }
        IRegion hyperlinkRegion = this.getHyperlinkRegion(node);
        IHyperlink hyperlink = this.createHyperlink(document, node, hyperlinkRegion);
        if (hyperlink != null) {
            hyperlinks.add(hyperlink);
        }
        if (hyperlinks.size() == 0) {
            return null;
        }
        return hyperlinks.toArray(new IHyperlink[0]);
    }

    private boolean isLinkable(IDOMNode node) {
        if (node == null) {
            return false;
        }
        short nodeType = node.getNodeType();
        boolean isLinkable = false;
        if (nodeType == 2) {
            IDOMAttr attr = (IDOMAttr)node;
            String name = attr.getName();
            isLinkable = this.isLinkableAttribute(name);
        }
        return isLinkable;
    }

    protected abstract boolean isLinkableAttribute(String var1);

    protected abstract IHyperlink createHyperlink(IDocument var1, IDOMNode var2, IRegion var3);

    protected IDOMNode getAttributeNode(int offset, IDOMNode parent) {
        IDOMAttr attrNode = null;
        NamedNodeMap map = parent.getAttributes();
        int index = 0;
        while (index < map.getLength()) {
            attrNode = (IDOMAttr)map.item(index);
            boolean located = attrNode.contains(offset);
            if (located) {
                if (!attrNode.hasNameOnly()) break;
                attrNode = null;
                break;
            }
            ++index;
        }
        if (attrNode == null) {
            return parent;
        }
        return attrNode;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IDOMNode getCurrentNode(IDocument document, int offset) {
        IndexedRegion inode;
        block5: {
            inode = null;
            IStructuredModel sModel = null;
            try {
                sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                inode = sModel.getIndexedRegion(offset);
                if (inode == null) {
                    inode = sModel.getIndexedRegion(offset - 1);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (sModel == null) throw throwable;
                sModel.releaseFromRead();
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (sModel == null) break block5;
            }
            sModel.releaseFromRead();
        }
        if (!(inode instanceof IDOMNode)) {
            return null;
        }
        IDOMNode node = (IDOMNode)inode;
        if (!node.hasAttributes()) return node;
        return this.getAttributeNode(offset, node);
    }

    protected IRegion getHyperlinkRegion(IDOMNode node) {
        if (node == null) {
            return null;
        }
        Region hyperRegion = null;
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 1: {
                hyperRegion = new Region(node.getStartOffset(), node.getEndOffset() - node.getStartOffset());
                break;
            }
            case 2: {
                IDOMAttr att = (IDOMAttr)node;
                int regOffset = att.getValueRegionStartOffset();
                ITextRegion valueRegion = att.getValueRegion();
                if (valueRegion == null) break;
                int regLength = valueRegion.getTextLength();
                String attValue = att.getValueRegionText();
                if (StringUtils.isQuoted((String)attValue)) {
                    regLength -= 2;
                    ++regOffset;
                }
                hyperRegion = new Region(regOffset, regLength);
                break;
            }
        }
        return hyperRegion;
    }
}

