/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.actions;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.XSDSelectionDispatchAction;
import org.eclipse.wst.xsd.ui.internal.refactor.structure.MakeLocalElementGlobalCommand;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Node;

public class MakeLocalElementGlobalAction
extends XSDSelectionDispatchAction {
    XSDElementDeclaration fSelectedComponent;

    public MakeLocalElementGlobalAction(ISelection selection, XSDSchema schema) {
        super(selection, schema);
        this.setText(RefactoringMessages.getString("MakeLocalElementGlobalAction.text"));
    }

    public boolean canRun() {
        return this.fSelectedComponent != null;
    }

    protected boolean canEnable(XSDConcreteComponent selectedObject) {
        XSDElementDeclaration element;
        this.fSelectedComponent = null;
        if (selectedObject instanceof XSDElementDeclaration && !(element = (XSDElementDeclaration)selectedObject).isElementDeclarationReference() && !element.isGlobal()) {
            this.fSelectedComponent = element;
        }
        return this.canRun();
    }

    protected boolean canEnable(Object selectedObject) {
        if (selectedObject instanceof XSDConcreteComponent) {
            return this.canEnable((XSDConcreteComponent)selectedObject) && super.canEnable(selectedObject);
        }
        if (selectedObject instanceof Node) {
            Node node = (Node)selectedObject;
            XSDConcreteComponent concreteComponent = this.getSchema().getCorrespondingComponent(node);
            return this.canEnable(concreteComponent) && super.canEnable(concreteComponent);
        }
        return false;
    }

    public void run() {
        DocumentImpl doc = (DocumentImpl)this.fSelectedComponent.getElement().getOwnerDocument();
        doc.getModel().beginRecording((Object)this, this.getText());
        MakeLocalElementGlobalCommand command = new MakeLocalElementGlobalCommand((XSDConcreteComponent)this.fSelectedComponent);
        command.run();
        doc.getModel().endRecording((Object)this);
    }
}

