/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.wizards;

import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;

class RegexNode {
    private String contents = "";
    private int min = -1;
    private int max = -1;
    private int repeat = -1;
    private int quantifier = 0;
    private boolean hasParens = false;
    private boolean autoEscapeStatus;
    public static final int SINGLE = 0;
    public static final int STAR = 1;
    public static final int PLUS = 2;
    public static final int OPTIONAL = 3;
    public static final int REPEAT = 4;
    public static final int RANGE = 5;
    private static final String[][] regexQuantifiers = new String[][]{{XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_QUANTIFIER_SINGLE"), ""}, {XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_QUANTIFIER_STAR"), "*"}, {XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_QUANTIFIER_PLUS"), "+"}, {XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_QUANTIFIER_OPTIONAL"), "?"}, {XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_QUANTIFIER_REPEAT"), ""}, {XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_QUANTIFIER_RANGE"), ""}};
    private static final String[][] regexTerms = new String[][]{{XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_TERM_ANY_CHAR"), "."}, {XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_TERM_ALPHANUMERIC_CHAR"), "\\w"}, {XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_TERM_WHITESPACE"), "\\s"}, {XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_TERM_DIGIT"), "\\d"}, {XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_TERM_UPPER"), "[A-Z]"}, {XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_TERM_LOWER"), "[a-z]"}, {XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_TERM_SELECTION"), ""}};
    public static final int SELECTION = regexTerms.length - 1;
    public static final int EMPTY = -1;
    private static final String metacharacters = ".\\?*+{}()[]";

    public static String getRegexTermText(int i) {
        if (i == SELECTION) {
            return regexTerms[i][0];
        }
        return String.valueOf(regexTerms[i][0]) + " ( " + regexTerms[i][1] + " )";
    }

    public static String getRegexTermValue(int i) {
        if (i == SELECTION) {
            return "";
        }
        return regexTerms[i][1];
    }

    public static int getNumRegexTerms() {
        return regexTerms.length;
    }

    public static String getQuantifierText(int i) {
        String result = regexQuantifiers[i][0];
        if (!regexQuantifiers[i][1].equals("")) {
            result = String.valueOf(result) + " ( ";
            result = String.valueOf(result) + regexQuantifiers[i][1];
            result = String.valueOf(result) + " )";
        }
        return result;
    }

    public String getContents() {
        return this.contents;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public int getQuantifier() {
        return this.quantifier;
    }

    public void setQuantifier(int quantifier) {
        this.quantifier = quantifier;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public boolean setMin(String min) {
        this.min = this.convertToInt(min);
        if (this.max != -1 && this.min > this.max) {
            return false;
        }
        return this.min >= 0;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public boolean setMax(String max) {
        this.max = this.convertToInt(max);
        if (max.equals("") && this.min != -1) {
            return true;
        }
        if (this.max < this.min) {
            return false;
        }
        return this.max >= 0;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public void setRepeat(int repeat) {
        this.repeat = repeat;
    }

    public boolean setRepeat(String repeat) {
        this.repeat = this.convertToInt(repeat);
        return this.repeat >= 0;
    }

    private int convertToInt(String s) {
        int result;
        try {
            result = Integer.parseInt(s);
            if (result < 0) {
                result = -1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            result = -1;
        }
        return result;
    }

    public boolean getHasParens() {
        return this.hasParens;
    }

    public void setHasParens(boolean status) {
        this.hasParens = status;
    }

    public boolean getAutoEscapeStatus() {
        return this.autoEscapeStatus;
    }

    public void setAutoEscapeStatus(boolean status) {
        this.autoEscapeStatus = status;
    }

    private String addEscapeCharacters(String s) {
        StringBuffer result = new StringBuffer("");
        int i = 0;
        while (i < s.length()) {
            char currentChar = s.charAt(i);
            if (this.isMetachar(currentChar)) {
                result.append("\\");
            }
            result.append(currentChar);
            ++i;
        }
        return result.toString();
    }

    private boolean isMetachar(char c) {
        return metacharacters.indexOf(c) != -1;
    }

    public boolean hasValidMin() {
        return this.min != -1;
    }

    public boolean hasValidMax() {
        return this.max != -1;
    }

    public boolean hasValidRepeat() {
        return this.repeat != -1;
    }

    public String toString() {
        String result = "";
        if (this.hasParens) {
            result = String.valueOf(result) + "(";
        }
        result = this.autoEscapeStatus ? String.valueOf(result) + this.addEscapeCharacters(this.contents) : String.valueOf(result) + this.contents;
        if (this.hasParens) {
            result = String.valueOf(result) + ")";
        }
        switch (this.quantifier) {
            case 1: {
                result = String.valueOf(result) + "*";
                break;
            }
            case 2: {
                result = String.valueOf(result) + "+";
                break;
            }
            case 3: {
                result = String.valueOf(result) + "?";
                break;
            }
            case 4: {
                result = String.valueOf(result) + "{" + this.repeat + "}";
                break;
            }
            case 5: {
                result = String.valueOf(result) + "{" + this.min + ",";
                result = this.max == -1 ? String.valueOf(result) : String.valueOf(result) + this.max;
                result = String.valueOf(result) + "}";
            }
        }
        return result;
    }
}

