/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.ui.refactoring;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.xtext.ui.refactoring.impl.RenameElementProcessor;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;
import org.eclipse.xtext.ui.util.DisplayRunnableWithResult;

public class XcoreRenameElementProcessor
extends RenameElementProcessor {
    @Inject
    @Named(value="languageName")
    private String languageName;
    @Inject(optional=true)
    private IWorkbench workbench;

    public boolean hasUnsavedEditors() {
        return (Boolean)new DisplayRunnableWithResult<Boolean>(){

            protected Boolean run() throws Exception {
                IWorkbenchPage workbenchPage = XcoreRenameElementProcessor.this.workbench.getActiveWorkbenchWindow().getActivePage();
                IEditorPart[] iEditorPartArray = workbenchPage.getDirtyEditors();
                int n = iEditorPartArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorPart editorPart = iEditorPartArray[n2];
                    if (XcoreRenameElementProcessor.this.languageName.equals(editorPart.getSite().getId())) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        }.syncExec();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (this.workbench != null && this.hasUnsavedEditors()) {
            ((StatusWrapper)this.getStatusProvider().get()).add(2, "Unsaved changes in Xcore editors could collide with this refactoring", new Object[0]);
        }
        return super.checkInitialConditions(monitor);
    }
}

