/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.UnusedCodeFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class UnnecessaryCodeCleanUpCore
extends AbstractMultiFix {
    public UnnecessaryCodeCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public UnnecessaryCodeCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.remove_unnecessary_casts");
        Map<String, String> requiredOptions = requireAST ? this.getRequiredOptions() : null;
        return new CleanUpRequirements(requireAST, false, false, requiredOptions);
    }

    @Override
    public ICleanUpFix createFix(CompilationUnit compilationUnit) throws CoreException {
        return UnusedCodeFixCore.createCleanUp(compilationUnit, false, false, false, false, false, false, this.isEnabled("cleanup.remove_unnecessary_casts"), false);
    }

    @Override
    public ICleanUpFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        return UnusedCodeFixCore.createCleanUp(compilationUnit, problems, false, false, false, false, false, false, this.isEnabled("cleanup.remove_unnecessary_casts"), false);
    }

    private Map<String, String> getRequiredOptions() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.remove_unnecessary_casts")) {
            result.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        }
        if (this.isEnabled("cleanup.remove_unused_method_parameters")) {
            result.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "warning");
        }
        return result;
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.remove_unnecessary_casts")) {
            result.add(MultiFixMessages.UnusedCodeCleanUp_RemoveUnusedCasts_description);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        StringBuilder buf = new StringBuilder();
        if (this.isEnabled("cleanup.remove_unnecessary_casts")) {
            buf.append("Boolean b= Boolean.TRUE;\n");
        } else {
            buf.append("Boolean b= (Boolean) Boolean.TRUE;\n");
        }
        return buf.toString();
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        if (problem.getProblemId() == 553648309) {
            return this.isEnabled("cleanup.remove_unnecessary_casts");
        }
        return false;
    }

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.remove_unnecessary_casts")) {
            result += UnnecessaryCodeCleanUpCore.getNumberOfProblems(problems, 553648309);
        }
        return result;
    }
}

