/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.ui.plugin;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;
import org.eclipse.wst.validation.internal.operations.ValidationOperation;
import org.eclipse.wst.validation.internal.ui.plugin.RunnableWithProgressWrapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ValidationUIPlugin
extends WTPUIPlugin {
    private static ValidationUIPlugin _plugin = null;
    public static final String VALIDATION_PROP_FILE_NAME = "validate_ui";
    public static final String VALIDATION_PLUGIN_ID = "org.eclipse.wst.validation.ui";
    public static final String[] ICON_DIRS = new String[]{"icons"};

    public ValidationUIPlugin() {
        if (_plugin == null) {
            _plugin = this;
        }
    }

    public static String getBundleName() {
        return VALIDATION_PROP_FILE_NAME;
    }

    public static ValidationUIPlugin getPlugin() {
        return _plugin;
    }

    public static String getResourceString(String key) {
        try {
            return Platform.getResourceString((Bundle)Platform.getBundle((String)VALIDATION_PLUGIN_ID), (String)key);
        }
        catch (Exception e) {
            ValidationUIPlugin.getPlugin().handleException(e);
            return key;
        }
    }

    public static IRunnableWithProgress getRunnableWithProgress(IWorkspaceRunnable aWorkspaceRunnable) {
        return new RunnableWithProgressWrapper(aWorkspaceRunnable);
    }

    public static IRunnableWithProgress getRunnableWithProgress(ValidationOperation op) {
        return new RunnableWithProgressWrapper(op);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public Image getImage(String key) {
        ImageDescriptor descriptor;
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key);
        if ((image == null || image.isDisposed()) && (descriptor = this.getImageDescriptor(key)) != null) {
            image = descriptor.createImage();
            imageRegistry.put(key, image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = null;
        URL gifImageURL = this.getImageURL(key);
        if (gifImageURL != null) {
            imageDescriptor = ImageDescriptor.createFromURL((URL)gifImageURL);
        }
        return imageDescriptor;
    }

    private URL getImageURL(String key) {
        return ValidationUIPlugin.getImageURL(key, this.getBundle());
    }

    public static URL getImageURL(String key, Bundle bundle) {
        String gif = "/" + key + ".gif";
        IPath path = null;
        int i = 0;
        while (i < ICON_DIRS.length) {
            path = new Path(ICON_DIRS[i]).append(gif);
            if (Platform.find((Bundle)bundle, (IPath)path) != null) {
                try {
                    return new URL(bundle.getEntry("/"), path.toString());
                }
                catch (MalformedURLException exception) {
                    exception.printStackTrace();
                }
            }
            ++i;
        }
        return null;
    }

    public void handleException(Throwable e) {
        Status status = new Status(4, "org.eclipse.wst.common.frameworks.ui", e.getLocalizedMessage(), e);
        this.getLog().log((IStatus)status);
    }

    public void logMessage(int severity, String message) {
        Status status = new Status(severity, "org.eclipse.wst.common.frameworks.ui", message);
        this.getLog().log((IStatus)status);
    }
}

