/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.epp.internal.mpc.core.util.ServiceUtil;
import org.eclipse.epp.internal.mpc.core.util.TransportFactory;
import org.eclipse.epp.mpc.core.service.ICatalogService;
import org.eclipse.epp.mpc.core.service.IMarketplaceService;
import org.eclipse.epp.mpc.core.service.IMarketplaceServiceLocator;
import org.eclipse.epp.mpc.core.service.IMarketplaceUnmarshaller;
import org.eclipse.epp.mpc.core.service.ITransportFactory;
import org.eclipse.epp.mpc.core.service.ServiceHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;

@Component(name="org.eclipse.epp.mpc.core.servicehelper", service={ServiceHelper.class, ServiceHelperImpl.class})
public class ServiceHelperImpl
extends ServiceHelper {
    private static ServiceHelperImpl instance;
    private ServiceTracker<IMarketplaceServiceLocator, IMarketplaceServiceLocator> locatorServiceTracker;
    private ServiceTracker<ITransportFactory, ITransportFactory> transportFactoryTracker;
    private ServiceTracker<ITransportFactory, TransportFactory> legacyTransportFactoryTracker;
    private ServiceTracker<IMarketplaceUnmarshaller, IMarketplaceUnmarshaller> unmarshallerTracker;
    private ComponentContext context;
    private List<ServiceRegistration<?>> serviceRegistrations;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    void activate(ComponentContext context) throws InvalidSyntaxException {
        this.context = context;
        BundleContext bundleContext = context.getBundleContext();
        this.registerServices(bundleContext);
        this.locatorServiceTracker = new ServiceTracker(bundleContext, IMarketplaceServiceLocator.class, null);
        this.locatorServiceTracker.open(true);
        this.transportFactoryTracker = new ServiceTracker(bundleContext, ITransportFactory.class, null);
        this.transportFactoryTracker.open(true);
        this.legacyTransportFactoryTracker = new TransportFactory.LegacyTransportFactoryTracker(bundleContext);
        this.legacyTransportFactoryTracker.open(true);
        this.unmarshallerTracker = new ServiceTracker(bundleContext, IMarketplaceUnmarshaller.class, null);
        this.unmarshallerTracker.open(true);
        Class<ServiceHelperImpl> clazz = ServiceHelperImpl.class;
        synchronized (ServiceHelperImpl.class) {
            if (instance == null) {
                instance = this;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    void deactivate(BundleContext context) {
        Class<ServiceHelperImpl> clazz = ServiceHelperImpl.class;
        synchronized (ServiceHelperImpl.class) {
            if (instance == this) {
                instance = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.context = null;
            if (this.locatorServiceTracker != null) {
                this.locatorServiceTracker.close();
                this.locatorServiceTracker = null;
            }
            if (this.transportFactoryTracker != null) {
                this.transportFactoryTracker.close();
                this.transportFactoryTracker = null;
            }
            if (this.legacyTransportFactoryTracker != null) {
                this.legacyTransportFactoryTracker.close();
                this.legacyTransportFactoryTracker = null;
            }
            if (this.unmarshallerTracker != null) {
                this.unmarshallerTracker.close();
                this.unmarshallerTracker = null;
            }
            this.unregisterServices();
            return;
        }
    }

    private void registerServices(BundleContext context) throws InvalidSyntaxException {
        int step;
        int maxLegacyPriority;
        ArrayList serviceRegistrations = new ArrayList();
        this.serviceRegistrations = serviceRegistrations;
        List<ITransportFactory> factories = TransportFactory.listAvailableFactories();
        if (factories.isEmpty()) {
            return;
        }
        Collection serviceReferences = context.getServiceReferences(ITransportFactory.class, null);
        int lowestPriority = Integer.MAX_VALUE;
        for (ServiceReference serviceReference : serviceReferences) {
            Object legacyProperty = serviceReference.getProperty("org.eclipse.epp.mpc.core.service.transport.legacy");
            if (legacyProperty != null) continue;
            Integer ranking = (Integer)serviceReference.getProperty("service.ranking");
            lowestPriority = Math.min(lowestPriority, ranking == null ? 0 : ranking);
        }
        if (lowestPriority >= 0) {
            maxLegacyPriority = -100;
            step = 100;
        } else {
            int available = lowestPriority - Integer.MIN_VALUE;
            step = Math.min(100, available / factories.size());
            if (step == 0) {
                step = 1;
                maxLegacyPriority = Integer.MIN_VALUE + factories.size();
            } else {
                maxLegacyPriority = lowestPriority - step;
            }
        }
        int prio = maxLegacyPriority;
        for (ITransportFactory factory : factories) {
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            properties.put("service.ranking", prio);
            properties.put("component.name", "legacy:" + factory.getClass().getName());
            properties.put("org.eclipse.epp.mpc.core.service.transport.legacy", true);
            ServiceRegistration registration = context.registerService(ITransportFactory.class, (Object)factory, properties);
            serviceRegistrations.add(registration);
            prio -= step;
        }
    }

    private void unregisterServices() {
        List<ServiceRegistration<?>> serviceRegistrations = this.serviceRegistrations;
        this.serviceRegistrations = null;
        if (serviceRegistrations != null) {
            for (ServiceRegistration<?> serviceRegistration : serviceRegistrations) {
                serviceRegistration.unregister();
            }
        }
    }

    @Override
    protected IMarketplaceServiceLocator doGetMarketplaceServiceLocator() {
        return this.locatorServiceTracker == null ? null : (IMarketplaceServiceLocator)this.locatorServiceTracker.getService();
    }

    @Override
    protected IMarketplaceUnmarshaller doGetMarketplaceUnmarshaller() {
        return this.unmarshallerTracker == null ? null : (IMarketplaceUnmarshaller)this.unmarshallerTracker.getService();
    }

    @Override
    protected ITransportFactory doGetTransportFactory() {
        return this.transportFactoryTracker == null ? null : (ITransportFactory)this.transportFactoryTracker.getService();
    }

    @Deprecated
    public TransportFactory getLegacyTransportFactory() {
        return this.legacyTransportFactoryTracker == null ? null : (TransportFactory)this.legacyTransportFactoryTracker.getService();
    }

    public ServiceRegistration<IMarketplaceServiceLocator> registerMarketplaceServiceLocator(IMarketplaceServiceLocator marketplaceServiceLocator) {
        return this.context.getBundleContext().registerService(IMarketplaceServiceLocator.class, (Object)marketplaceServiceLocator, ServiceUtil.higherServiceRanking(this.locatorServiceTracker.getServiceReference(), null));
    }

    public ServiceRegistration<IMarketplaceUnmarshaller> registerMarketplaceUnmarshaller(IMarketplaceUnmarshaller unmarshaller) {
        return this.context.getBundleContext().registerService(IMarketplaceUnmarshaller.class, (Object)unmarshaller, ServiceUtil.higherServiceRanking(this.unmarshallerTracker.getServiceReference(), null));
    }

    public ServiceRegistration<ITransportFactory> registerTransportFactory(ITransportFactory transportFactory) {
        return this.context.getBundleContext().registerService(ITransportFactory.class, (Object)transportFactory, ServiceUtil.higherServiceRanking(this.transportFactoryTracker.getServiceReference(), null));
    }

    public ServiceRegistration<IMarketplaceService> registerMarketplaceService(String baseUrl, IMarketplaceService marketplaceService) {
        Dictionary<String, Object> properties = ServiceUtil.serviceRanking(Integer.MAX_VALUE, null);
        properties.put("url", baseUrl);
        return this.context.getBundleContext().registerService(IMarketplaceService.class, (Object)marketplaceService, properties);
    }

    public ServiceRegistration<ICatalogService> registerCatalogService(ICatalogService catalogService) {
        return this.context.getBundleContext().registerService(ICatalogService.class, (Object)catalogService, ServiceUtil.serviceRanking(Integer.MAX_VALUE, null));
    }

    public void setSuspended(boolean suspend) throws Exception {
        String pid = (String)this.context.getProperties().get("service.pid");
        if (suspend) {
            this.context.disableComponent(pid);
            this.unregisterServices();
        } else {
            this.context.enableComponent(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceHelperImpl getImplInstance() {
        Class<ServiceHelperImpl> clazz = ServiceHelperImpl.class;
        synchronized (ServiceHelperImpl.class) {
            if (instance == null) {
                ServiceHelperImpl registered = ServiceUtil.getService(ServiceHelperImpl.class, ServiceHelperImpl.class);
                if (instance == null && registered != null) {
                    instance = registered;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

