/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.egit.ui.internal.synchronize.GitModelSynchronize;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;

public class SynchronizeCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
        final String refName = this.getRefName(node);
        if (refName == null) {
            return null;
        }
        String secondRefName = "HEAD";
        if (this.getSelectedNodes(event).size() == 2 && (secondRefName = this.getRefName((RepositoryTreeNode)this.getSelectedNodes(event).get(1))) == null) {
            return null;
        }
        final String secondRefNameParam = secondRefName;
        final boolean includeLocal = this.getSelectedNodes(event).size() == 1;
        final Repository repo = node.getRepository();
        WorkspaceJob job = new WorkspaceJob(NLS.bind((String)UIText.SynchronizeCommand_jobName, (Object)repo.getDirectory())){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    GitSynchronizeData data = new GitSynchronizeData(repo, secondRefNameParam, refName, includeLocal);
                    Set projects = data.getProjects();
                    IResource[] resources = projects.toArray(new IResource[0]);
                    GitModelSynchronize.launch(data, resources);
                }
                catch (IOException e) {
                    Activator.logError((String)e.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    private String getRefName(RepositoryTreeNode node) {
        Object object = node.getObject();
        if (!(object instanceof Ref)) {
            return null;
        }
        Ref ref = (Ref)object;
        return ref.getName();
    }
}

