/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.spy.bundle;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.net.URL;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.spy.bundle.Messages;
import org.eclipse.pde.spy.bundle.internal.BundleDataFilter;
import org.eclipse.pde.spy.bundle.internal.BundleDataProvider;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

public class BundleSpyPart {
    private static final String ICON_REFRESH = "icons/refresh.svg";
    public static final String ICON_STATE_ACTIVE = "icons/state_active.svg";
    public static final String ICON_STATE_STARTING = "icons/state_starting.svg";
    public static final String ICON_STATE_STOPPING = "icons/state_stopping.svg";
    public static final String ICON_STATE_RESOLVED = "icons/state_resolved.svg";
    public static final String ICON_STATE_INSTALLED = "icons/state_installed.svg";
    public static final String ICON_STATE_UNINSTALLED = "icons/state_uninstalled.svg";
    public static final String ICON_START = "icons/start.svg";
    public static final String ICON_STOP = "icons/stop.svg";
    private TableViewer bundlesTableViewer;
    private Text filterText;
    private Button showOnlyFilteredElements;
    private BundleDataFilter bundleFilter;
    @Inject
    private IEclipseContext ctx;
    private static String lastFilterText = null;
    private static boolean lastShowFiltered = false;
    private static final ViewerFilter[] NO_FILTER = new ViewerFilter[0];
    private Button stopButton;
    private Button startButton;

    @PostConstruct
    public void createControls(Composite parent) {
        ImageRegistry imgReg = this.initializeImageRegistry();
        this.bundleFilter = new BundleDataFilter();
        this.ctx.set(BundleDataFilter.class, (Object)this.bundleFilter);
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(5, false));
        Button refreshButton = new Button(comp, 0x800000);
        refreshButton.setImage(imgReg.get(ICON_REFRESH));
        refreshButton.setToolTipText(Messages.BundleSpyPart_9);
        refreshButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.bundlesTableViewer.refresh(true)));
        this.filterText = new Text(comp, 896);
        GridDataFactory.fillDefaults().hint(200, -1).applyTo((Control)this.filterText);
        this.filterText.setMessage(Messages.BundleSpyPart_10);
        this.filterText.setToolTipText(Messages.BundleSpyPart_11);
        if (lastFilterText != null) {
            this.filterText.setText(lastFilterText);
        }
        this.bundleFilter.setPattern(lastFilterText);
        this.filterText.addKeyListener(KeyListener.keyReleasedAdapter(e -> {
            String textToSearch;
            lastFilterText = textToSearch = this.filterText.getText();
            boolean enableButton = textToSearch.length() > 0;
            this.showOnlyFilteredElements.setEnabled(enableButton);
            this.bundleFilter.setPattern(textToSearch);
            this.setFilter();
            this.bundlesTableViewer.refresh(true);
        }));
        this.showOnlyFilteredElements = new Button(comp, 32);
        this.showOnlyFilteredElements.setText(Messages.BundleSpyPart_12);
        this.showOnlyFilteredElements.setToolTipText(Messages.BundleSpyPart_13);
        this.showOnlyFilteredElements.setEnabled(lastFilterText != null && lastFilterText.length() > 0);
        this.showOnlyFilteredElements.setSelection(lastShowFiltered);
        this.showOnlyFilteredElements.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            lastShowFiltered = this.showOnlyFilteredElements.getSelection();
            this.setFilter();
        }));
        this.startButton = new Button(comp, 0x800000);
        this.startButton.setImage(imgReg.get(ICON_START));
        this.startButton.setToolTipText(Messages.BundleSpyPart_14);
        this.startButton.setEnabled(false);
        this.startButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection sel = (IStructuredSelection)this.bundlesTableViewer.getSelection();
            for (Bundle b : sel) {
                try {
                    b.start();
                }
                catch (BundleException e1) {
                    e1.printStackTrace();
                }
            }
            this.bundlesTableViewer.refresh();
            this.updateButtonStatuses(sel);
        }));
        this.stopButton = new Button(comp, 0x800000);
        this.stopButton.setImage(imgReg.get(ICON_STOP));
        this.stopButton.setToolTipText(Messages.BundleSpyPart_15);
        this.stopButton.setEnabled(false);
        this.stopButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (MessageDialog.openConfirm((Shell)((Control)e.getSource()).getShell(), (String)Messages.BundleSpyPart_16, (String)Messages.BundleSpyPart_17)) {
                IStructuredSelection sel = (IStructuredSelection)this.bundlesTableViewer.getSelection();
                for (Bundle b : sel) {
                    try {
                        b.stop();
                    }
                    catch (BundleException e1) {
                        e1.printStackTrace();
                    }
                }
                this.bundlesTableViewer.refresh();
                this.updateButtonStatuses(sel);
            }
        }));
        this.bundlesTableViewer = new TableViewer(parent);
        Table cTable = this.bundlesTableViewer.getTable();
        cTable.setHeaderVisible(true);
        cTable.setLinesVisible(true);
        GridData gd_cTable = new GridData(4, 4, true, true);
        cTable.setLayoutData((Object)gd_cTable);
        this.addColumn(this.bundlesTableViewer, 35, Messages.BundleSpyPart_18, 2);
        this.addColumn(this.bundlesTableViewer, 200, Messages.BundleSpyPart_19, 0);
        this.addColumn(this.bundlesTableViewer, 200, Messages.BundleSpyPart_20, 1);
        this.bundlesTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        BundleContext bc = FrameworkUtil.getBundle(BundleSpyPart.class).getBundleContext();
        this.bundlesTableViewer.setInput((Object)bc.getBundles());
        this.bundlesTableViewer.addSelectionChangedListener(event -> this.updateButtonStatuses((IStructuredSelection)event.getSelection()));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.bundlesTableViewer);
    }

    protected void updateButtonStatuses(IStructuredSelection selection) {
        boolean oneBundleIsActive = false;
        boolean oneBundleIsNotActive = false;
        for (Bundle b : selection) {
            oneBundleIsActive = oneBundleIsActive || b.getState() == 32;
            boolean bl = oneBundleIsNotActive = oneBundleIsNotActive || b.getState() != 32;
        }
        this.startButton.setEnabled(oneBundleIsNotActive);
        this.stopButton.setEnabled(oneBundleIsActive);
    }

    private void addColumn(final TableViewer parentTable, int width, String title, final int column) {
        TableViewerColumn col = new TableViewerColumn(this.bundlesTableViewer, 0);
        col.getColumn().setWidth(width);
        col.getColumn().setText(title);
        final BundleDataProvider bdp = (BundleDataProvider)((Object)ContextInjectionFactory.make(BundleDataProvider.class, (IEclipseContext)this.ctx));
        bdp.setColumn(column);
        col.setLabelProvider((CellLabelProvider)bdp);
        col.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){
            private int turnAround = 1;

            public void widgetSelected(SelectionEvent e) {
                this.turnAround *= -1;
                parentTable.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        if (2 == column) {
                            Bundle b1 = (Bundle)e1;
                            Bundle b2 = (Bundle)e2;
                            return this.turnAround(Integer.compare(b1.getState(), b2.getState()));
                        }
                        return this.turnAround(bdp.getText(e1).compareTo(bdp.getText(e2)));
                    }
                });
            }

            private int turnAround(int compare) {
                return compare * this.turnAround;
            }
        });
    }

    public void setFilter() {
        if (this.showOnlyFilteredElements.isEnabled() && this.showOnlyFilteredElements.getSelection()) {
            this.bundlesTableViewer.setFilters(new ViewerFilter[]{this.bundleFilter});
        } else {
            this.bundlesTableViewer.setFilters(NO_FILTER);
        }
    }

    @Focus
    public void setFocus() {
        this.bundlesTableViewer.getControl().setFocus();
    }

    private ImageRegistry initializeImageRegistry() {
        Bundle b = FrameworkUtil.getBundle(this.getClass());
        ImageRegistry imgReg = new ImageRegistry();
        imgReg.put(ICON_REFRESH, ImageDescriptor.createFromURL((URL)b.getEntry(ICON_REFRESH)));
        imgReg.put(ICON_STATE_ACTIVE, ImageDescriptor.createFromURL((URL)b.getEntry(ICON_STATE_ACTIVE)));
        imgReg.put(ICON_STATE_RESOLVED, ImageDescriptor.createFromURL((URL)b.getEntry(ICON_STATE_RESOLVED)));
        imgReg.put(ICON_STATE_STARTING, ImageDescriptor.createFromURL((URL)b.getEntry(ICON_STATE_STARTING)));
        imgReg.put(ICON_STATE_STOPPING, ImageDescriptor.createFromURL((URL)b.getEntry(ICON_STATE_STOPPING)));
        imgReg.put(ICON_STATE_INSTALLED, ImageDescriptor.createFromURL((URL)b.getEntry(ICON_STATE_INSTALLED)));
        imgReg.put(ICON_STATE_UNINSTALLED, ImageDescriptor.createFromURL((URL)b.getEntry(ICON_STATE_UNINSTALLED)));
        imgReg.put(ICON_START, ImageDescriptor.createFromURL((URL)b.getEntry(ICON_START)));
        imgReg.put(ICON_STOP, ImageDescriptor.createFromURL((URL)b.getEntry(ICON_STOP)));
        this.ctx.set(ImageRegistry.class, (Object)imgReg);
        return imgReg;
    }
}

