/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.spy.event.internal.ui;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.Collection;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.pde.spy.event.internal.core.EventMonitor;
import org.eclipse.pde.spy.event.internal.model.CapturedEvent;
import org.eclipse.pde.spy.event.internal.model.CapturedEventFilter;
import org.eclipse.pde.spy.event.internal.ui.CapturedEventFilters;
import org.eclipse.pde.spy.event.internal.ui.CapturedEventTree;
import org.eclipse.pde.spy.event.internal.ui.Messages;
import org.eclipse.pde.spy.event.internal.ui.SpyPartMemento;
import org.eclipse.pde.spy.event.internal.ui.ToggleLink;
import org.eclipse.pde.spy.event.internal.util.JDTUtils;
import org.eclipse.pde.spy.event.internal.util.LoggerWrapper;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class EventSpyPart
implements EventMonitor.NewEventListener {
    private static final String[] SHOW_FILTER_LINK_TEXT = new String[]{Messages.EventSpyPart_ShowFilters, Messages.EventSpyPart_HideFilters};
    private CapturedEventTree capturedEventTree;
    private CapturedEventFilters capturedEventFilters;
    private Composite outer;
    private EventMonitor eventMonitor;
    private ToggleLink showFiltersLink;
    @Inject
    private LoggerWrapper logger;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private MApplication appplication;

    @PostConstruct
    protected void createDialogArea(Composite parent, @Optional SpyPartMemento memento) {
        this.outer = parent;
        this.outer.setLayout((Layout)new GridLayout());
        this.outer.setLayoutData((Object)new GridData(1808));
        this.createActionBar(this.outer);
        this.createFilters(memento);
        this.createCapturedEventTree(this.outer);
    }

    @PreDestroy
    private void saveDialogMemento() {
        SpyPartMemento memento = null;
        String baseTopic = this.capturedEventFilters.getBaseTopic();
        Collection<CapturedEventFilter> filters = this.capturedEventFilters.getFilters();
        IEclipseContext context = this.appplication.getContext();
        if (!"org/eclipse/e4/ui/*".equals(baseTopic)) {
            memento = new SpyPartMemento();
            memento.setBaseTopic(baseTopic);
        }
        if (!filters.isEmpty()) {
            if (memento == null) {
                memento = new SpyPartMemento();
            }
            memento.setFilters(filters);
        }
        if (memento != null) {
            context.set(SpyPartMemento.class.getName(), (Object)memento);
        } else if (context.containsKey(SpyPartMemento.class.getName())) {
            context.remove(SpyPartMemento.class.getName());
        }
    }

    private void createActionBar(Composite parent) {
        Composite actionBar = new Composite(parent, 0);
        GridData gridData = this.createDefaultGridData();
        gridData.grabExcessVerticalSpace = false;
        actionBar.setLayoutData((Object)gridData);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.spacing = 20;
        actionBar.setLayout((Layout)rowLayout);
        ToggleLink link = new ToggleLink(actionBar);
        link.setText(new String[]{Messages.EventSpyPart_StartCapturingEvents, Messages.EventSpyPart_StopCapturingEvents});
        link.setClickListener(toggled -> {
            if (toggled) {
                this.captureEvents();
            } else {
                this.stopCaptureEvents();
            }
        });
        this.showFiltersLink = new ToggleLink(actionBar);
        this.showFiltersLink.setText(new String[]{SHOW_FILTER_LINK_TEXT[0], SHOW_FILTER_LINK_TEXT[1]});
        this.showFiltersLink.getControl().setLayoutData((Object)new RowData(130, -1));
        this.showFiltersLink.setClickListener(this::showFilters);
    }

    private void createFilters(SpyPartMemento memento) {
        this.capturedEventFilters = new CapturedEventFilters(this.outer);
        this.capturedEventFilters.getControl().setVisible(false);
        GridData gridData = this.createDefaultGridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.exclude = true;
        this.capturedEventFilters.getControl().setLayoutData((Object)gridData);
        if (memento != null) {
            this.capturedEventFilters.setBaseTopic(memento.getBaseTopic());
            this.capturedEventFilters.setFilters(memento.getFilters());
        }
        this.showFilters(false);
    }

    private void createCapturedEventTree(Composite parent) {
        this.capturedEventTree = new CapturedEventTree(this.outer);
        this.capturedEventTree.getControl().setLayoutData((Object)this.createDefaultGridData());
        this.capturedEventTree.setListener(this::openResource);
    }

    public void captureEvents() {
        this.capturedEventTree.removeAll();
        if (this.eventMonitor == null) {
            this.eventMonitor = new EventMonitor(this.eventBroker);
            this.eventMonitor.setNewEventListener(this);
        }
        this.eventMonitor.start(this.capturedEventFilters.getBaseTopic(), this.capturedEventFilters.getFilters());
    }

    public void stopCaptureEvents() {
        if (this.eventMonitor != null) {
            this.eventMonitor.stop();
        }
    }

    @Override
    public void newEvent(CapturedEvent event) {
        this.capturedEventTree.addEvent(event);
    }

    private void openResource(String text) {
        try {
            JDTUtils.openClass(text);
        }
        catch (ClassNotFoundException exc) {
            this.logger.warn(exc.getMessage());
        }
    }

    private void showFilters(boolean filtersVisible) {
        this.capturedEventFilters.getControl().setVisible(filtersVisible);
        boolean bl = ((GridData)this.capturedEventFilters.getControl().getLayoutData()).exclude = !filtersVisible;
        if (!filtersVisible && this.capturedEventFilters.hasFilters()) {
            this.showFiltersLink.setText(new String[]{String.format("%s (%d)", SHOW_FILTER_LINK_TEXT[0], this.capturedEventFilters.getFiltersCount()), SHOW_FILTER_LINK_TEXT[1]});
        } else {
            this.showFiltersLink.setText(new String[]{SHOW_FILTER_LINK_TEXT[0], SHOW_FILTER_LINK_TEXT[1]});
        }
        this.outer.layout(false);
    }

    private GridData createDefaultGridData() {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 2;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        return gridData;
    }
}

