/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.codegen.jet.JETAttributeItem;
import org.eclipse.emf.codegen.jet.JETAttributeListItem;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETItem;
import org.eclipse.emf.codegen.jet.JETMark;
import org.eclipse.emf.codegen.jet.JETProblemListener;
import org.eclipse.emf.codegen.jet.JETTokenItem;
import org.eclipse.emf.codegen.jet.JETValueElementItem;
import org.eclipse.emf.codegen.jet.JETValueItem;

public class JETReader {
    protected char startTagInitialChar = (char)60;
    protected char endTagInitialChar = (char)37;
    protected char endTagFinalChar = (char)62;
    protected JETMark current;
    protected JETMark start;
    @Deprecated
    protected String master;
    protected List<String> sourceFiles = new ArrayList<String>();
    protected List<String> baseURIs = new ArrayList<String>();
    protected int size;
    protected boolean trimExtraNewLine = true;
    protected List<String> resolvedURIs = new ArrayList<String>();
    protected final LinkedList<JETItem> jetItems = new LinkedList();
    protected JETProblemListener problemListener;

    public JETReader(String baseURI, String locationURI, InputStream inputStream, String encoding, JETProblemListener problemListener) throws JETException {
        this.stackStream(baseURI, locationURI, inputStream, encoding);
        this.problemListener = problemListener;
    }

    @Deprecated
    public JETReader(String baseURI, String locationURI, InputStream inputStream, String encoding) throws JETException {
        this(baseURI, locationURI, inputStream, encoding, new JETProblemListener());
    }

    public JETReader(String locationURI, InputStream inputStream, String encoding) throws JETException {
        this(null, locationURI, inputStream, encoding);
    }

    public String getFile(int fileid) {
        return this.sourceFiles.get(fileid);
    }

    public String getBaseURI(int fileid) {
        return this.baseURIs.get(fileid);
    }

    public String getResolvedURI(int fileid) {
        return this.resolvedURIs.get(fileid);
    }

    public void stackStream(String locationURI, InputStream iStream, String encoding) throws JETException {
        this.stackStream(null, locationURI, iStream, encoding);
    }

    public void stackStream(String baseURI, String locationURI, InputStream iStream, String encoding) throws JETException {
        if (encoding == null) {
            encoding = "UTF8";
        }
        int fileid = this.registerSourceFile(locationURI);
        this.registerBaseURI(baseURI);
        this.registerResolvedURI(baseURI, locationURI);
        InputStreamReader reader = null;
        try {
            try {
                reader = new InputStreamReader(iStream, encoding);
                CharArrayWriter writer = new CharArrayWriter();
                char[] buf = new char[1024];
                int i = 0;
                while ((i = reader.read(buf)) != -1) {
                    if (buf[0] == '\ufeff') {
                        writer.write(buf, 1, i - 1);
                        continue;
                    }
                    writer.write(buf, 0, i);
                }
                writer.close();
                if (this.current == null) {
                    this.start = this.current = new JETMark(this, writer.toCharArray(), fileid, locationURI, encoding);
                } else {
                    this.current.pushStream(writer.toCharArray(), fileid, locationURI, encoding);
                }
            }
            catch (UnsupportedEncodingException exception) {
                this.start = new JETMark(this, new char[0], fileid, locationURI, encoding);
                throw new JETException(exception);
            }
            catch (IOException exception) {
                this.start = new JETMark(this, new char[0], fileid, locationURI, encoding);
                throw new JETException(exception);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {
                    throw new JETException(exception);
                }
            }
        }
    }

    public boolean popFile() {
        if (this.current == null) {
            return false;
        }
        --this.size;
        return this.current.popStream();
    }

    protected int registerSourceFile(String file) {
        this.sourceFiles.add(file);
        ++this.size;
        return this.sourceFiles.size() - 1;
    }

    protected void registerBaseURI(String baseURI) {
        this.baseURIs.add(baseURI);
    }

    protected void registerResolvedURI(String baseURI, String file) {
        this.resolvedURIs.add(String.valueOf(baseURI) + "/" + file);
    }

    public boolean hasMoreInput() {
        if (this.current.cursor < this.current.stream.length) {
            return true;
        }
        boolean nl = this.hasTrailingNewLine();
        while (this.popFile()) {
            if (this.current.cursor >= this.current.stream.length) continue;
            if (this.trimExtraNewLine && nl) {
                this.skipNewLine();
            }
            return true;
        }
        return false;
    }

    protected boolean hasTrailingNewLine() {
        char[] stream = this.current.stream;
        int i = stream.length - 1;
        while (i >= 0) {
            if (stream[i] == '\n' || stream[i] == '\r') {
                return true;
            }
            if (stream[i] != ' ') {
                return false;
            }
            --i;
        }
        return false;
    }

    protected void skipNewLine() {
        char[] stream = this.current.stream;
        int c = this.current.cursor;
        if (stream.length > c + 1 && (stream[c] == '\n' && stream[c + 1] == '\r' || stream[c] == '\r' && stream[c + 1] == '\n')) {
            this.current.cursor += 2;
            ++this.current.line;
            this.current.col = stream[0] == '\n' ? 1 : 0;
        } else if (stream.length > c && (stream[c] == '\n' || stream[c] == '\r')) {
            ++this.current.cursor;
            ++this.current.line;
            this.current.col = 0;
        }
    }

    public int nextChar() {
        if (!this.hasMoreInput()) {
            return -1;
        }
        char ch = this.current.stream[this.current.cursor];
        ++this.current.cursor;
        if (ch == '\n') {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        return ch;
    }

    public JETItem popItem() {
        return this.jetItems.isEmpty() ? null : this.jetItems.removeFirst();
    }

    public void pushItem(JETItem jetItem) {
        this.jetItems.addFirst(jetItem);
    }

    public String nextContent() {
        int cur_cursor = this.current.cursor;
        int len = this.current.stream.length;
        if (cur_cursor == len) {
            return "";
        }
        char ch = this.current.stream[this.current.cursor];
        do {
            if (ch == '\n') {
                ++this.current.line;
                this.current.col = 0;
            } else {
                ++this.current.col;
            }
            ++this.current.cursor;
        } while (this.current.cursor < len && (ch = this.current.stream[this.current.cursor]) != this.startTagInitialChar);
        return new String(this.current.stream, cur_cursor, this.current.cursor - cur_cursor);
    }

    public char[] getChars(JETMark start, JETMark stop) {
        JETMark oldstart = this.mark();
        this.reset(start);
        CharArrayWriter writer = new CharArrayWriter();
        while (!stop.equals(this.mark())) {
            writer.write(this.nextChar());
        }
        writer.close();
        this.reset(oldstart);
        return writer.toCharArray();
    }

    public int peekChar() {
        return this.current.cursor < this.current.stream.length ? this.current.stream[this.current.cursor] : -1;
    }

    public JETMark mark() {
        return new JETMark(this.current);
    }

    public void reset(JETMark mark) {
        this.current = new JETMark(mark);
    }

    public boolean matchesIgnoreCase(String string) {
        JETMark mark = this.mark();
        int ch = 0;
        int i = 0;
        do {
            if (Character.toLowerCase((char)(ch = this.nextChar())) == string.charAt(i++)) continue;
            this.reset(mark);
            return false;
        } while (i < string.length());
        this.reset(mark);
        return true;
    }

    public boolean matches(String string) {
        return this.matches(string, false);
    }

    public boolean matches(String string, boolean word) {
        JETMark mark = this.mark();
        int ch = 0;
        int i = 0;
        do {
            if ((char)(ch = this.nextChar()) == string.charAt(i++)) continue;
            this.reset(mark);
            return false;
        } while (i < string.length());
        boolean result = !word || !Character.isLetterOrDigit(this.peekChar());
        this.reset(mark);
        return result;
    }

    public void advance(int n) {
        while (--n >= 0) {
            this.nextChar();
        }
    }

    public int skipSpaces() {
        int i = 0;
        while (this.isSpace()) {
            ++i;
            this.nextChar();
        }
        return i;
    }

    public JETMark skipUntil(String limit) {
        JETMark ret = null;
        int limlen = limit.length();
        ret = this.mark();
        int ch = this.nextChar();
        while (ch != -1) {
            block4: {
                if (ch == limit.charAt(0)) {
                    int i = 1;
                    while (i < limlen) {
                        if (this.nextChar() != limit.charAt(i)) {
                            this.reset(ret);
                            this.nextChar();
                            break block4;
                        }
                        ++i;
                    }
                    return ret;
                }
            }
            ret = this.mark();
            ch = this.nextChar();
        }
        return null;
    }

    protected boolean isSpace() {
        int peekChar = this.peekChar();
        return peekChar <= 32 && peekChar != -1;
    }

    public String parseToken(boolean quoted) throws JETException {
        StringBuilder stringBuilder = new StringBuilder();
        this.skipSpaces();
        int ch = this.peekChar();
        char quote = '\u0000';
        JETMark start = this.mark();
        JETMark quoteStart = null;
        JETMark quoteStop = null;
        ArrayList<JETValueElementItem> values = null;
        if (quoted) {
            if (ch == 34 || ch == 39) {
                JETValueElementItem valueElementItem;
                quote = (char)ch;
                ch = this.nextChar();
                quoteStart = quoteStop = this.mark();
                StringBuilder valueBuilder = new StringBuilder();
                JETMark valueStart = quoteStart;
                values = new ArrayList();
                ch = this.nextChar();
                while (ch != -1 && ch != quote) {
                    if (ch == 92 && (ch = this.nextChar()) == -1) break;
                    if (ch > 32) {
                        valueBuilder.append((char)ch);
                        if ((this.peekChar() <= 32 || this.peekChar() == quote) && valueBuilder.length() > 0) {
                            valueElementItem = new JETValueElementItem(valueStart, this.mark(), valueBuilder.toString());
                            values.add(valueElementItem);
                            valueBuilder.setLength(0);
                        }
                    } else {
                        valueStart = this.mark();
                    }
                    stringBuilder.append((char)ch);
                    quoteStop = this.mark();
                    ch = this.nextChar();
                }
                if (ch == -1) {
                    this.reset(quoteStart);
                    stringBuilder.setLength(0);
                    quoteStop = quoteStart;
                    ch = this.nextChar();
                    while (ch != -1) {
                        if (ch == this.endTagInitialChar && this.peekChar() == this.endTagFinalChar) break;
                        stringBuilder.append(ch);
                        quoteStop = this.mark();
                        ch = this.nextChar();
                    }
                    this.problemListener.handleProblem(quoteStart, quoteStop, 4, null, "jet.error.quotes.unterminated", quoteStart.format("jet.mark.file.line.column"));
                    values.clear();
                    valueElementItem = new JETValueElementItem(quoteStart, quoteStop, stringBuilder.toString());
                    values.add(valueElementItem);
                }
            } else {
                quoteStart = quoteStop = this.mark();
                ch = this.nextChar();
                while (ch != -1) {
                    if (ch == this.endTagInitialChar && this.peekChar() == this.endTagFinalChar) {
                        this.reset(quoteStop);
                        break;
                    }
                    stringBuilder.append(ch);
                    quoteStop = this.mark();
                    ch = this.nextChar();
                }
                values = new ArrayList<JETValueElementItem>();
                this.problemListener.handleProblem(quoteStart, quoteStop, 4, null, "jet.error.attr.quoted", quoteStart.format("jet.mark.file.line.column"));
                JETValueElementItem valueElementItem = new JETValueElementItem(quoteStart, quoteStop, stringBuilder.toString());
                values.add(valueElementItem);
            }
        } else if (!this.isDelimiter()) {
            do {
                int peekChar;
                if ((ch = this.nextChar()) == 92 && ((peekChar = this.peekChar()) == 34 || peekChar == 39 || peekChar == this.endTagFinalChar || peekChar == this.endTagInitialChar)) {
                    ch = this.nextChar();
                }
                stringBuilder.append((char)ch);
            } while (!this.isDelimiter());
        }
        String result = stringBuilder.toString();
        JETMark stop = this.mark();
        if (quoteStart != null) {
            this.pushItem(new JETTokenItem(start, stop, String.valueOf(quote) + result + quote, new JETValueItem(quoteStart, quoteStop, result, values)));
        } else {
            this.pushItem(new JETTokenItem(start, stop, result));
        }
        return stringBuilder.toString();
    }

    protected void parseAttributeValue(HashMap<String, String> into) throws JETException {
        this.skipSpaces();
        JETMark start = this.mark();
        String name = this.parseToken(false);
        JETTokenItem nameToken = (JETTokenItem)this.popItem();
        this.skipSpaces();
        if (this.peekChar() != 61) {
            JETMark stop = this.mark();
            this.problemListener.handleProblem(start, stop, 4, null, "jet.error.attr.novalue", name, stop.format("jet.mark.file.line.column"));
        } else {
            this.nextChar();
        }
        this.skipSpaces();
        String value = this.parseToken(true);
        JETTokenItem valueToken = (JETTokenItem)this.popItem();
        JETMark stop = this.mark();
        this.pushItem(new JETAttributeItem(start, stop, nameToken, valueToken));
        into.put(name, value);
    }

    @Deprecated
    public HashMap<String, String> parseTagAttributesBean() throws JETException {
        HashMap<String, String> values = new HashMap<String, String>(11);
        JETMark start = this.mark();
        while (true) {
            this.skipSpaces();
            int ch = this.peekChar();
            if (ch == this.endTagFinalChar) {
                return values;
            }
            if (ch == 47) {
                JETMark mark = this.mark();
                this.nextChar();
                try {
                    if (this.nextChar() == this.endTagFinalChar) {
                        HashMap<String, String> hashMap = values;
                        return hashMap;
                    }
                }
                finally {
                    this.reset(mark);
                }
            }
            if (ch == -1) break;
            this.parseAttributeValue(values);
        }
        this.problemListener.handleProblem(start, this.mark(), 4, null, "jet.error.tag.attr.unterminated", this.mark().format("jet.mark.file.line.column"));
        return new HashMap<String, String>();
    }

    public HashMap<String, String> parseTagAttributes() throws JETException {
        HashMap<String, String> values;
        JETMark start;
        block27: {
            JETMark mark;
            this.skipSpaces();
            JETMark stop = start = this.mark();
            values = new HashMap<String, String>(11);
            ArrayList<JETAttributeItem> attributes = new ArrayList<JETAttributeItem>();
            while (true) {
                int ch;
                block26: {
                    block25: {
                        ch = this.peekChar();
                        if (ch == this.endTagFinalChar) {
                            HashMap<String, String> hashMap = values;
                            return hashMap;
                        }
                        if (ch == 45) {
                            mark = this.mark();
                            this.nextChar();
                            if (this.nextChar() == 45) {
                                if (this.nextChar() == this.endTagFinalChar) {
                                    HashMap<String, String> hashMap = values;
                                    return hashMap;
                                }
                            }
                        }
                        if (ch != this.endTagInitialChar) break block25;
                        mark = this.mark();
                        this.nextChar();
                        if (this.nextChar() == this.endTagFinalChar) {
                            HashMap<String, String> hashMap = values;
                            return hashMap;
                        }
                        break block26;
                    }
                    if (ch == 47) {
                        mark = this.mark();
                        this.nextChar();
                        if (this.nextChar() != this.endTagFinalChar) break block26;
                        HashMap<String, String> hashMap = values;
                        return hashMap;
                    }
                }
                if (ch == -1) {
                    break block27;
                }
                this.parseAttributeValue(values);
                attributes.add((JETAttributeItem)this.popItem());
                stop = this.mark();
                this.skipSpaces();
            }
            finally {
                this.reset(mark);
            }
            finally {
                this.reset(mark);
            }
            {
                finally {
                    this.reset(mark);
                }
            }
            finally {
                this.pushItem(new JETAttributeListItem(start, stop, attributes));
            }
        }
        this.problemListener.handleProblem(start, this.mark(), 4, null, "jet.error.tag.attr.unterminated", start.format("jet.mark.file.line.column"));
        return values;
    }

    protected boolean isDelimiter() {
        if (!this.isSpace()) {
            int ch = this.peekChar();
            if (ch == -1) {
                return true;
            }
            if (ch == 61 || ch == this.endTagFinalChar || ch == 34 || ch == 39 || ch == 47 || ch == this.endTagInitialChar) {
                return true;
            }
            if (ch == 45) {
                JETMark mark = this.mark();
                ch = this.nextChar();
                if (ch == this.endTagFinalChar || ch == 45 && this.nextChar() == this.endTagFinalChar) {
                    this.reset(mark);
                    return true;
                }
                this.reset(mark);
                return false;
            }
            return false;
        }
        return true;
    }

    public void setStartTag(String startTag) {
        this.startTagInitialChar = startTag.charAt(0);
    }

    public void setEndTag(String endTag) {
        this.endTagFinalChar = endTag.charAt(endTag.length() - 1);
        this.endTagInitialChar = endTag.charAt(0);
    }
}

