/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.common;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.tools.emf.ui.common.IProviderStatusCallback;
import org.eclipse.e4.tools.emf.ui.common.ResourceSearchScope;

public interface IClassContributionProvider {
    public void findContribution(Filter var1, ContributionResultHandler var2);

    public static class ContributionData {
        public final String bundleName;
        public final String className;
        public final String sourceType;
        public final String iconPath;
        public String installLocation;
        public String resourceRelativePath;

        public ContributionData(String bundleName, String className, String sourceType, String iconPath) {
            this.bundleName = bundleName;
            this.className = className;
            this.sourceType = sourceType;
            this.iconPath = iconPath;
        }
    }

    public static interface ContributionResultHandler {
        public static final int MORE_UNKNOWN = -1;
        public static final int MORE_CANCELED = -2;

        public void result(ContributionData var1);

        public void moreResults(int var1, Filter var2);
    }

    public static class Filter {
        public final IProject project;
        public final String namePattern;
        public int maxResults;
        public Object userData;
        private List<String> bundles;
        private List<String> packages;
        private List<String> locations;
        private EnumSet<ResourceSearchScope> searchScope = EnumSet.noneOf(ResourceSearchScope.class);
        private boolean includeNonBundles;
        private IProgressMonitor progressMonitor;
        private IProviderStatusCallback providerStatusCallback;

        public Filter(IProject project, String namePattern) {
            this.project = project;
            this.namePattern = namePattern;
        }

        public void setBundles(List<String> filterBundles) {
            this.bundles = filterBundles;
        }

        public void setPackages(List<String> filterPackages) {
            this.packages = filterPackages;
        }

        public List<String> getBundles() {
            return this.bundles;
        }

        public List<String> getPackages() {
            return this.packages;
        }

        public List<String> getLocations() {
            return this.locations;
        }

        public void setLocations(List<String> locations) {
            this.locations = locations;
        }

        public EnumSet<ResourceSearchScope> getSearchScope() {
            return this.searchScope;
        }

        public void setSearchScope(EnumSet<ResourceSearchScope> searchScope) {
            this.searchScope = searchScope;
        }

        public void setIncludeNonBundles(boolean includeNonBundles) {
            this.includeNonBundles = includeNonBundles;
        }

        public boolean isIncludeNonBundles() {
            return this.includeNonBundles;
        }

        public IProgressMonitor getProgressMonitor() {
            return this.progressMonitor;
        }

        public void setProgressMonitor(IProgressMonitor progressMonitor) {
            this.progressMonitor = progressMonitor;
        }

        public IProviderStatusCallback getProviderStatusCallback() {
            return this.providerStatusCallback;
        }

        public void setProviderStatusCallback(IProviderStatusCallback providerStatusCallback) {
            this.providerStatusCallback = providerStatusCallback;
        }
    }
}

