/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.e4.tools.emf.ui.common.IModelElementProvider;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelResultHandlerImpl
implements IModelElementProvider.ModelResultHandler {
    private boolean canceled = false;
    private final IObservableList<Object> list;
    private final IModelElementProvider.Filter filter;
    private final AbstractComponentEditor<?> editor;
    private final Resource resource;

    public ModelResultHandlerImpl(IObservableList<Object> list, IModelElementProvider.Filter filter, AbstractComponentEditor<?> editor, Resource resource) {
        this.list = list;
        this.filter = filter;
        this.editor = editor;
        this.resource = resource;
    }

    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void result(EObject data) {
        if (!this.canceled && !this.resource.getURI().equals(data.eResource().getURI()) && data instanceof MApplicationElement) {
            String elementId = ((MApplicationElement)data).getElementId();
            if (elementId == null) {
                this.list.add((Object)data);
                return;
            }
            if (elementId.trim().length() > 0 && this.filter.elementIdPattern.matcher(elementId).matches()) {
                this.list.add((Object)data);
                return;
            }
            String label = this.editor.getDetailLabel(data);
            if (label != null && label.trim().length() > 0 && this.filter.elementIdPattern.matcher(label).matches()) {
                this.list.add((Object)data);
                return;
            }
        }
    }
}

