/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.catalog.CatalogContributorRegistryReader;
import org.eclipse.wst.xml.core.internal.catalog.CatalogElement;
import org.eclipse.wst.xml.core.internal.catalog.CatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.CatalogEvent;
import org.eclipse.wst.xml.core.internal.catalog.CatalogReader;
import org.eclipse.wst.xml.core.internal.catalog.CatalogSet;
import org.eclipse.wst.xml.core.internal.catalog.CatalogWriter;
import org.eclipse.wst.xml.core.internal.catalog.DelegateCatalog;
import org.eclipse.wst.xml.core.internal.catalog.NextCatalog;
import org.eclipse.wst.xml.core.internal.catalog.RewriteEntry;
import org.eclipse.wst.xml.core.internal.catalog.SuffixEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogElement;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEvent;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogListener;
import org.eclipse.wst.xml.core.internal.catalog.provisional.IDelegateCatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.IRewriteEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ISuffixEntry;

public class Catalog
implements ICatalog {
    private static Comparator LONGEST_REWRITE_FIRST = new Comparator(){

        public int compare(Object entry1, Object entry2) {
            String start1 = ((IRewriteEntry)entry1).getStartString();
            String start2 = ((IRewriteEntry)entry2).getStartString();
            return start2.length() - start1.length();
        }
    };
    private static Comparator LONGEST_SUFFIX_FIRST = new Comparator(){

        public int compare(Object entry1, Object entry2) {
            String suffix1 = ((ISuffixEntry)entry1).getSuffix();
            String suffix2 = ((ISuffixEntry)entry2).getSuffix();
            return suffix2.length() - suffix1.length();
        }
    };
    private static Comparator LONGEST_DELEGATE_PREFIX_FIRST = new Comparator(){

        public int compare(Object entry1, Object entry2) {
            String prefix1 = ((IDelegateCatalog)entry1).getStartString();
            String prefix2 = ((IDelegateCatalog)entry2).getStartString();
            return prefix2.length() - prefix1.length();
        }
    };
    public static final String DEFAULT_CATALOG_FILE = "default_catalog.xml";
    public static final String SYSTEM_CATALOG_FILE = "system_catalog.xml";
    public static final String USER_CATALOG_FILE = "user_catalog.xml";
    protected String base;
    protected List catalogElements = new ArrayList();
    protected CatalogLS catalogLS;
    protected String id;
    protected InternalResolver internalResolver;
    protected boolean isNotificationEnabled;
    protected List listenerList = new ArrayList();
    protected String location;
    protected CatalogSet resourceSet;

    public Catalog(CatalogSet catalogResourceSet, String id, String location) {
        this.resourceSet = catalogResourceSet;
        this.id = id;
        this.location = location;
        this.catalogLS = "default_catalog".equals(id) ? new DefaultCatalogLS() : ("system_catalog".equals(id) ? new SystemCatalogLS() : new UserCatalogLS());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCatalogElement(ICatalogElement element) {
        List list = this.catalogElements;
        synchronized (list) {
            this.catalogElements.add(element);
        }
        element.setOwnerCatalog(this);
        this.internalResolver = null;
        this.notifyAddElement(element);
    }

    @Override
    public void addEntriesFromCatalog(ICatalog catalog) {
        try {
            this.setNotificationEnabled(false);
            if (catalog != null) {
                ICatalogElement[] entries = ((Catalog)catalog).getCatalogElements();
                int i = 0;
                while (i < entries.length) {
                    CatalogElement clone = (CatalogElement)((CatalogElement)entries[i]).clone();
                    this.addCatalogElement(clone);
                    ++i;
                }
            } else {
                Logger.log(4, "argument was null in Catalog.addEntriesFromCatalog");
            }
        }
        finally {
            this.setNotificationEnabled(true);
        }
        this.internalResolver = null;
        this.notifyChanged();
    }

    @Override
    public void addListener(ICatalogListener listener) {
        this.listenerList.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List list = this.catalogElements;
        synchronized (list) {
            this.catalogElements.clear();
        }
        this.internalResolver = null;
        this.notifyChanged();
    }

    @Override
    public ICatalogElement createCatalogElement(int type) {
        switch (type) {
            case 1: {
                return new CatalogEntry();
            }
            case 10: {
                return new NextCatalog();
            }
            case 2: 
            case 3: 
            case 4: {
                return new CatalogEntry(type);
            }
            case 20: 
            case 21: 
            case 22: {
                return new RewriteEntry(type);
            }
            case 40: 
            case 41: 
            case 42: {
                return new SuffixEntry(type);
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return new DelegateCatalog(type);
            }
        }
        throw new IllegalArgumentException("Unknown element type " + type);
    }

    public String getBase() {
        return this.base;
    }

    private List getCatalogElements(int type) {
        ArrayList<ICatalogElement> result = new ArrayList<ICatalogElement>();
        ICatalogElement[] elements = this.catalogElements.toArray(new ICatalogElement[this.catalogElements.size()]);
        int i = 0;
        while (i < elements.length) {
            ICatalogElement element = elements[i];
            if (element.getType() == type) {
                result.add(element);
            }
            ++i;
        }
        return result;
    }

    @Override
    public ICatalogEntry[] getCatalogEntries() {
        List result = this.getCatalogElements(1);
        return result.toArray(new ICatalogEntry[result.size()]);
    }

    @Override
    public IDelegateCatalog[] getDelegateCatalogs() {
        List result = this.getCatalogElements(30);
        return result.toArray(new IDelegateCatalog[result.size()]);
    }

    @Override
    public IRewriteEntry[] getRewriteEntries() {
        List result = this.getCatalogElements(20);
        return result.toArray(new IRewriteEntry[result.size()]);
    }

    @Override
    public ISuffixEntry[] getSuffixEntries() {
        List result = this.getCatalogElements(40);
        return result.toArray(new ISuffixEntry[result.size()]);
    }

    protected CatalogSet getCatalogSet() {
        return this.resourceSet;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public INextCatalog[] getNextCatalogs() {
        List result = this.getCatalogElements(10);
        return result.toArray(new INextCatalog[result.size()]);
    }

    protected InternalResolver getOrCreateInternalResolver() {
        if (this.internalResolver == null) {
            this.internalResolver = new InternalResolver();
        }
        return this.internalResolver;
    }

    protected boolean isNotificationEnabled() {
        return this.isNotificationEnabled;
    }

    public void load() throws IOException {
        this.catalogLS.load();
    }

    protected void notifyAddElement(ICatalogElement entry) {
        if (this.isNotificationEnabled) {
            CatalogEvent event = new CatalogEvent(this, entry, 1);
            this.notifyListeners(event);
        }
    }

    protected void notifyChanged() {
        CatalogEvent event = new CatalogEvent(this, null, 0);
        this.notifyListeners(event);
    }

    protected void notifyListeners(ICatalogEvent event) {
        ArrayList list = new ArrayList();
        list.addAll(this.listenerList);
        for (ICatalogListener listener : list) {
            listener.catalogChanged(event);
        }
    }

    protected void notifyRemoveElement(ICatalogElement element) {
        if (this.isNotificationEnabled) {
            CatalogEvent event = new CatalogEvent(this, element, 2);
            this.notifyListeners(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCatalogElement(ICatalogElement element) {
        List list = this.catalogElements;
        synchronized (list) {
            this.catalogElements.remove(element);
        }
        this.internalResolver = null;
        this.notifyRemoveElement(element);
    }

    @Override
    public void removeListener(ICatalogListener listener) {
        this.listenerList.remove(listener);
    }

    @Override
    public String resolvePublic(String publicId, String systemId) throws MalformedURLException, IOException {
        return this.getOrCreateInternalResolver().resolvePublic(publicId, systemId);
    }

    protected String resolveSubordinateCatalogs(int entryType, String publicId, String systemId) throws MalformedURLException, IOException {
        String result = null;
        INextCatalog[] nextCatalogs = this.getNextCatalogs();
        int i = 0;
        while (i < nextCatalogs.length) {
            INextCatalog nextCatalog = nextCatalogs[i];
            ICatalog catalog = nextCatalog.getReferencedCatalog();
            if (catalog != null) {
                switch (entryType) {
                    case 2: {
                        result = catalog.resolvePublic(publicId, systemId);
                        break;
                    }
                    case 3: {
                        result = catalog.resolveSystem(systemId);
                        break;
                    }
                    case 4: {
                        result = catalog.resolveURI(systemId);
                        break;
                    }
                }
                if (result != null) {
                    return result;
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public String resolveSystem(String systemId) throws MalformedURLException, IOException {
        return this.getOrCreateInternalResolver().resolveSystem(systemId);
    }

    @Override
    public String resolveURI(String uri) throws MalformedURLException, IOException {
        return this.getOrCreateInternalResolver().resolveURI(uri);
    }

    @Override
    public void save() throws IOException {
        this.catalogLS.save();
    }

    public void setBase(String base) {
        this.base = base;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    protected void setNotificationEnabled(boolean b) {
        this.isNotificationEnabled = b;
    }

    public ICatalogElement[] getCatalogElements() {
        return this.catalogElements.toArray(new ICatalogElement[this.catalogElements.size()]);
    }

    class CatalogLS {
        CatalogLS() {
        }

        public void load() {
        }

        public synchronized void save() {
            try {
                new CatalogWriter().write((ICatalog)Catalog.this, Catalog.this.location);
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
    }

    class DefaultCatalogLS
    extends CatalogLS {
        DefaultCatalogLS() {
        }

        @Override
        public void load() {
            NextCatalog userCatalogReference = new NextCatalog();
            userCatalogReference.setId("user_catalog");
            userCatalogReference.setCatalogLocation(Catalog.USER_CATALOG_FILE);
            Catalog.this.addCatalogElement(userCatalogReference);
            NextCatalog systemCatalogReference = new NextCatalog();
            systemCatalogReference.setId("system_catalog");
            systemCatalogReference.setCatalogLocation(Catalog.SYSTEM_CATALOG_FILE);
            Catalog.this.addCatalogElement(systemCatalogReference);
            this.save();
        }
    }

    class InternalResolver {
        protected Map publicMap = new HashMap();
        protected Map systemMap = new HashMap();
        protected Map uriMap = new HashMap();
        protected List rewriteSystemList = new LinkedList();
        protected List rewriteUriList = new LinkedList();
        protected List suffixSystemList = new LinkedList();
        protected List suffixUriList = new LinkedList();
        protected List delegatePublicList = new LinkedList();
        protected List delegateSystemList = new LinkedList();
        protected List delegateUriList = new LinkedList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InternalResolver() {
            List list = Catalog.this.catalogElements;
            synchronized (list) {
                for (ICatalogElement catalogElement : Catalog.this.catalogElements) {
                    ICatalogElement entry;
                    if (catalogElement.getType() == 1) {
                        entry = (ICatalogEntry)catalogElement;
                        Map map = this.getEntryMap(entry.getEntryType());
                        map.put(entry.getKey(), entry);
                        continue;
                    }
                    if (catalogElement.getType() == 20) {
                        entry = (IRewriteEntry)catalogElement;
                        if (entry.getEntryType() == 21) {
                            this.rewriteSystemList.add(entry);
                            continue;
                        }
                        this.rewriteUriList.add(entry);
                        continue;
                    }
                    if (catalogElement.getType() == 40) {
                        entry = (ISuffixEntry)catalogElement;
                        if (entry.getEntryType() == 41) {
                            this.suffixSystemList.add(entry);
                            continue;
                        }
                        this.suffixUriList.add(entry);
                        continue;
                    }
                    if (catalogElement.getType() != 30) continue;
                    IDelegateCatalog delegate = (IDelegateCatalog)catalogElement;
                    if (delegate.getEntryType() == 31) {
                        this.delegatePublicList.add(delegate);
                        continue;
                    }
                    if (delegate.getEntryType() == 32) {
                        this.delegateSystemList.add(delegate);
                        continue;
                    }
                    this.delegateUriList.add(delegate);
                }
            }
            Collections.sort(this.rewriteSystemList, LONGEST_REWRITE_FIRST);
            Collections.sort(this.rewriteUriList, LONGEST_REWRITE_FIRST);
            Collections.sort(this.suffixSystemList, LONGEST_SUFFIX_FIRST);
            Collections.sort(this.suffixUriList, LONGEST_SUFFIX_FIRST);
            Collections.sort(this.delegatePublicList, LONGEST_DELEGATE_PREFIX_FIRST);
            Collections.sort(this.delegateSystemList, LONGEST_DELEGATE_PREFIX_FIRST);
            Collections.sort(this.delegateUriList, LONGEST_DELEGATE_PREFIX_FIRST);
        }

        private Map getEntryMap(int entryType) {
            Map map = this.systemMap;
            switch (entryType) {
                case 2: {
                    map = this.publicMap;
                    break;
                }
                case 4: {
                    map = this.uriMap;
                    break;
                }
            }
            return map;
        }

        protected String getMappedURI(Map map, String key) {
            CatalogEntry entry = (CatalogEntry)map.get(key);
            if (entry == null) {
                return null;
            }
            Object uri = entry.getURI();
            try {
                String FILE_SCHEME;
                URL entryURL;
                if (((String)uri).startsWith("platform:") && ((String)(uri = Platform.resolve((URL)(entryURL = new URL(entry.getAbsolutePath((String)uri)))).toString())).startsWith(FILE_SCHEME = "file:") && !((String)uri).startsWith(FILE_SCHEME + "/")) {
                    uri = FILE_SCHEME + "///" + ((String)uri).substring(FILE_SCHEME.length());
                }
                return uri;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public String resolvePublic(String publicId, String systemId) throws MalformedURLException, IOException {
            String result = this.getMappedURI(this.publicMap, publicId);
            if (result == null) {
                result = this.getMappedURI(this.systemMap, systemId);
            }
            if (result == null) {
                result = this.getMappedURI(this.uriMap, publicId);
            }
            if (result == null) {
                result = this.resolveDelegateCatalogs(this.delegatePublicList, publicId, systemId);
            }
            if (result == null) {
                result = Catalog.this.resolveSubordinateCatalogs(2, publicId, systemId);
            }
            return result;
        }

        public String resolveSystem(String systemId) throws MalformedURLException, IOException {
            String result = this.getMappedURI(this.systemMap, systemId);
            if (result == null) {
                result = this.resolveRewrite(this.rewriteSystemList, systemId);
            }
            if (result == null) {
                result = this.resolveSuffix(this.suffixSystemList, systemId);
            }
            if (result == null) {
                result = this.resolveDelegateCatalogs(this.delegateSystemList, systemId, systemId);
            }
            if (result == null) {
                result = Catalog.this.resolveSubordinateCatalogs(3, null, systemId);
            }
            return result;
        }

        private String resolveRewrite(List rewriteList, String searchString) {
            for (IRewriteEntry entry : rewriteList) {
                String startString = entry.getStartString();
                if (!searchString.startsWith(startString)) continue;
                return entry.getRewritePrefix() + searchString.substring(startString.length());
            }
            return null;
        }

        private String resolveSuffix(List suffixList, String searchString) {
            for (ISuffixEntry entry : suffixList) {
                if (!searchString.endsWith(entry.getSuffix())) continue;
                return entry.getURI();
            }
            return null;
        }

        protected String resolveDelegateCatalogs(List delegateCatalogs, String key, String systemId) throws MalformedURLException, IOException {
            String result = null;
            for (IDelegateCatalog delegate : delegateCatalogs) {
                ICatalog catalog;
                if (!key.startsWith(delegate.getStartString()) || (catalog = delegate.getReferencedCatalog()) == null) continue;
                switch (delegate.getEntryType()) {
                    case 31: {
                        result = catalog.resolvePublic(key, systemId);
                        break;
                    }
                    case 32: {
                        result = catalog.resolveSystem(systemId);
                        break;
                    }
                    case 33: {
                        result = catalog.resolveURI(systemId);
                        break;
                    }
                }
                if (result == null) continue;
                return result;
            }
            return null;
        }

        public String resolveURI(String uri) throws MalformedURLException, IOException {
            String result = this.getMappedURI(this.uriMap, uri);
            if (result == null) {
                result = this.resolveRewrite(this.rewriteUriList, uri);
            }
            if (result == null) {
                result = this.resolveSuffix(this.suffixUriList, uri);
            }
            if (result == null) {
                result = this.resolveDelegateCatalogs(this.delegateUriList, uri, uri);
            }
            if (result == null) {
                result = Catalog.this.resolveSubordinateCatalogs(4, null, uri);
            }
            return result;
        }
    }

    class SystemCatalogLS
    extends CatalogLS {
        SystemCatalogLS() {
        }

        @Override
        public void load() {
            new CatalogContributorRegistryReader(Catalog.this).readRegistry();
            this.save();
        }
    }

    class UserCatalogLS
    extends CatalogLS {
        UserCatalogLS() {
        }

        @Override
        public void load() {
            block19: {
                InputStream inputStream = null;
                try {
                    try {
                        if (Catalog.this.location != null && Catalog.this.location.length() > 0) {
                            URL url = new URL(Catalog.this.location);
                            inputStream = url.openStream();
                            boolean oldNotificationEnabled = Catalog.this.isNotificationEnabled();
                            Catalog.this.setNotificationEnabled(false);
                            Catalog.this.clear();
                            try {
                                CatalogReader.read(Catalog.this, inputStream);
                            }
                            finally {
                                Catalog.this.setNotificationEnabled(oldNotificationEnabled);
                            }
                        } else {
                            Catalog.this.clear();
                        }
                        Catalog.this.notifyChanged();
                    }
                    catch (Exception exception) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception2) {}
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

