/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.grammarAccess;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.inject.Binder;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.XtextRuntimeModule;
import org.eclipse.xtext.formatting.ILineSeparatorInformation;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.service.CompoundModule;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.eclipse.xtext.xtext.RuleNames;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrGrammarGenUtil;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrOptions;

public class GrammarAccessExtensions {
    private static Map<String, String> SPECIAL_CHARS = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"\b", (Object)"backspace"), Pair.of((Object)"\f", (Object)"formFeed"), Pair.of((Object)"\n", (Object)"lineFeed"), Pair.of((Object)"\r", (Object)"carriageReturn"), Pair.of((Object)"\t", (Object)"tab"), Pair.of((Object)"\\", (Object)"backslash")}));
    @Inject
    @Extension
    private XtextGeneratorNaming _xtextGeneratorNaming;
    @Inject
    private CodeConfig codeConfig;

    public TypeReference getGrammarAccess(Grammar grammar) {
        String _runtimeBasePackage = this._xtextGeneratorNaming.getRuntimeBasePackage(grammar);
        String _plus = _runtimeBasePackage + ".services.";
        String _simpleName = GrammarUtil.getSimpleName((Grammar)grammar);
        String _plus_1 = _plus + _simpleName;
        String _plus_2 = _plus_1 + "GrammarAccess";
        return new TypeReference(_plus_2);
    }

    public StringConcatenationClient gaFullAccessor(final AbstractElement ele) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                TypeReference _grammarAccess = GrammarAccessExtensions.this.getGrammarAccess(GrammarUtil.getGrammar((EObject)ele));
                _builder.append((Object)_grammarAccess);
                _builder.append((Object)".INSTANCE.");
                String _gaRuleElementAccessor = GrammarAccessExtensions.this.gaRuleElementAccessor(ele);
                _builder.append((Object)_gaRuleElementAccessor);
            }
        };
        return _client;
    }

    public String toJavaIdentifier(String text, boolean uppercaseFirst) {
        try {
            return this.toJavaIdentifierSegment(text, true, uppercaseFirst);
        }
        catch (Throwable _t) {
            if (_t instanceof Throwable) {
                Throwable t = _t;
                t.printStackTrace();
                return "%_FAILURE_(" + text + ")%";
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private String toJavaIdentifier(List<String> text, boolean uppercaseFirst) {
        Iterator<String> i = text.iterator();
        String _javaIdentifierSegment = this.toJavaIdentifierSegment(i.next(), true, uppercaseFirst);
        StringBuilder b = new StringBuilder(_javaIdentifierSegment);
        while (i.hasNext()) {
            b.append(this.toJavaIdentifierSegment(i.next(), false, true));
        }
        return b.toString();
    }

    private String toJavaIdentifierSegment(String text, boolean isFirst, boolean uppercaseFirst) {
        char[] _charArray;
        boolean _greaterThan;
        String special = SPECIAL_CHARS.get(text);
        if (special != null) {
            String _xifexpression = null;
            _xifexpression = uppercaseFirst ? StringExtensions.toFirstUpper((String)special) : special;
            return _xifexpression;
        }
        String r = this.toJavaIdentifierSegmentInt(text, isFirst, uppercaseFirst);
        int _length = r.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            return r;
        }
        StringBuilder builder = new StringBuilder();
        char[] cArray = _charArray = text.toCharArray();
        int n = _charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            String n3 = this.getUnicodeName(c);
            if (n3 != null) {
                builder.append(n3 + " ");
            }
            ++n2;
        }
        return this.toJavaIdentifierSegmentInt(builder.toString().toLowerCase().trim(), isFirst, true);
    }

    public String getUnicodeName(char character) {
        return Character.getName(character);
    }

    private String toJavaIdentifierSegmentInt(String text, boolean isFirst, boolean uppercaseFirst) {
        char[] _charArray;
        boolean start = isFirst;
        boolean up = true;
        StringBuilder builder = new StringBuilder();
        char[] cArray = _charArray = text.toCharArray();
        int n = _charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            boolean valid = this.isValidJavaLatinIdentifier(c, start);
            if (valid) {
                if (start) {
                    char _xifexpression = '\u0000';
                    _xifexpression = uppercaseFirst ? Character.toUpperCase(c) : Character.toLowerCase(c);
                    builder.append(_xifexpression);
                } else {
                    char _xifexpression_1 = '\u0000';
                    _xifexpression_1 = up ? Character.toUpperCase(c) : c;
                    builder.append(_xifexpression_1);
                }
                up = false;
                start = false;
            } else {
                up = true;
            }
            ++n2;
        }
        return builder.toString();
    }

    public boolean isValidJavaLatinIdentifier(char c, boolean start) {
        boolean valid = c >= 'A' && c <= 'Z';
        valid = valid || c >= 'a' && c <= 'z';
        valid = valid || GrammarAccessExtensions.eq(c, '\u00e4') || GrammarAccessExtensions.eq(c, '\u00f6') || GrammarAccessExtensions.eq(c, '\u00fc') || GrammarAccessExtensions.eq(c, '\u00c4') || GrammarAccessExtensions.eq(c, '\u00d6') || GrammarAccessExtensions.eq(c, '\u00dc');
        boolean bl = valid = valid || GrammarAccessExtensions.eq(c, '_');
        if (!start) {
            valid = valid || c >= '0' && c <= '9';
        }
        return valid;
    }

    private static boolean eq(char c1, char c2) {
        return c1 == c2;
    }

    public String gaRuleIdentifier(AbstractRule rule) {
        String plainName = RuleNames.getRuleNames((AbstractRule)rule).getUniqueRuleName(rule);
        return this.toJavaIdentifier(plainName, true);
    }

    public String gaBaseRuleIdentifier(AbstractRule rule) {
        return this.toJavaIdentifier(rule.getName(), true);
    }

    public String gaElementIdentifier(AbstractElement element) {
        block4: {
            try {
                if (element != null) break block4;
                return "null";
            }
            catch (Throwable _t) {
                if (_t instanceof Throwable) {
                    Throwable t = _t;
                    t.printStackTrace();
                    return "failure";
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getElementDescription(element));
        result.add(this.getElementTypeDescription(element));
        result.add(this.getElementPath(element));
        return this.toJavaIdentifier(result, true);
    }

    private List<String> getElementDescription(AbstractElement element) {
        ArrayList<String> result = new ArrayList<String>();
        AbstractElement container = element;
        while (container != null) {
            result.addAll(0, this.getSingleElementDescription(container));
            EObject eContainer = container.eContainer();
            AbstractElement _xifexpression = null;
            _xifexpression = eContainer instanceof AbstractElement ? (AbstractElement)eContainer : null;
            container = _xifexpression;
        }
        return result;
    }

    private List<String> getSingleElementDescription(AbstractElement ele) {
        boolean _tripleNotEquals;
        EClassifier _classifier;
        TypeRef _type;
        String _name;
        ArrayList<String> r = new ArrayList<String>(2);
        boolean _matched = false;
        if (ele instanceof Keyword) {
            _matched = true;
            String _value = ((Keyword)ele).getValue();
            r.add(_value);
        }
        if (!_matched && ele instanceof Assignment) {
            _matched = true;
            String _feature = ((Assignment)ele).getFeature();
            r.add(_feature);
        }
        if (!_matched && ele instanceof RuleCall) {
            _matched = true;
            _name = ((RuleCall)ele).getRule().getName();
            r.add(_name);
        }
        if (!_matched && ele instanceof Action) {
            boolean _isNullOrEmpty;
            boolean _not;
            _matched = true;
            _type = ((Action)ele).getType();
            _classifier = null;
            if (_type != null) {
                _classifier = _type.getClassifier();
            }
            boolean bl = _tripleNotEquals = _classifier != null;
            if (_tripleNotEquals) {
                String _name2 = ((Action)ele).getType().getClassifier().getName();
                r.add(_name2);
            }
            boolean bl2 = _not = !(_isNullOrEmpty = StringExtensions.isNullOrEmpty((String)((Action)ele).getFeature()));
            if (_not) {
                String _feature = ((Action)ele).getFeature();
                r.add(_feature);
            }
        }
        if (!_matched && ele instanceof CrossReference) {
            _matched = true;
            _type = ((CrossReference)ele).getType();
            _classifier = null;
            if (_type != null) {
                _classifier = _type.getClassifier();
            }
            boolean bl = _tripleNotEquals = _classifier != null;
            if (_tripleNotEquals) {
                String _name3 = ((CrossReference)ele).getType().getClassifier().getName();
                r.add(_name3);
            }
        }
        if (!_matched && ele instanceof EnumLiteralDeclaration) {
            _matched = true;
            _name = ((EnumLiteralDeclaration)ele).getEnumLiteral().getName();
            r.add(_name);
        }
        return r;
    }

    private String getElementTypeDescription(AbstractElement ele) {
        Object _xifexpression = null;
        if (ele instanceof RuleCall) {
            String _name = ((RuleCall)ele).getRule().eClass().getName();
            _xifexpression = _name + "Call";
        } else {
            _xifexpression = ele.eClass().getName();
        }
        return _xifexpression;
    }

    private String getElementPath(AbstractElement ele) {
        AbstractElement obj = ele;
        StringBuilder result = new StringBuilder();
        while (!(obj.eContainer() instanceof AbstractRule) && obj.eContainer() != null) {
            EObject eContainer = obj.eContainer();
            result.insert(0, eContainer.eContents().indexOf((Object)obj));
            result.insert(0, "_");
            obj = eContainer;
        }
        return result.toString();
    }

    public String gaRuleAccessMethodName(AbstractRule rule) {
        String _gaRuleIdentifier = this.gaRuleIdentifier(rule);
        String _plus = "get" + _gaRuleIdentifier;
        return _plus + "Rule";
    }

    public String gaBaseRuleAccessMethodName(AbstractRule rule) {
        String _gaBaseRuleIdentifier = this.gaBaseRuleIdentifier(rule);
        String _plus = "get" + _gaBaseRuleIdentifier;
        return _plus + "Rule";
    }

    public String gaRuleElementsMethodName(AbstractRule rule) {
        String _gaRuleIdentifier = this.gaRuleIdentifier(rule);
        String _plus = "get" + _gaRuleIdentifier;
        return _plus + "Access";
    }

    public String gaBaseRuleElementsMethodName(AbstractRule rule) {
        String _gaBaseRuleIdentifier = this.gaBaseRuleIdentifier(rule);
        String _plus = "get" + _gaBaseRuleIdentifier;
        return _plus + "Access";
    }

    public String gaElementAccessMethodName(AbstractElement element) {
        String _gaElementIdentifier = this.gaElementIdentifier(element);
        return "get" + _gaElementIdentifier;
    }

    public String gaRuleAccessorClassName(AbstractRule rule) {
        String _gaRuleIdentifier = this.gaRuleIdentifier(rule);
        return _gaRuleIdentifier + "Elements";
    }

    public String gaBaseRuleAccessorClassName(AbstractRule rule) {
        String _gaBaseRuleIdentifier = this.gaBaseRuleIdentifier(rule);
        return _gaBaseRuleIdentifier + "Elements";
    }

    public String gaRuleAccessor(AbstractRule rule) {
        String _gaRuleAccessMethodName = this.gaRuleAccessMethodName(rule);
        return _gaRuleAccessMethodName + "()";
    }

    public String gaRuleParameterAccessor(Parameter parameter) {
        ParserRule rule = GrammarUtil.containingParserRule((EObject)parameter);
        int index = rule.getParameters().indexOf((Object)parameter);
        String _gaRuleAccessor = this.gaRuleAccessor((AbstractRule)rule);
        String _plus = _gaRuleAccessor + ".getParameters().get(";
        String _plus_1 = _plus + String.valueOf((Object)index);
        String _plus_2 = _plus_1 + "/*";
        String _name = parameter.getName();
        String _plus_3 = _plus_2 + _name;
        return _plus_3 + "*/)";
    }

    public String gaBaseRuleAccessor(AbstractRule rule) {
        String _gaBaseRuleAccessMethodName = this.gaBaseRuleAccessMethodName(rule);
        return _gaBaseRuleAccessMethodName + "()";
    }

    public String gaElementsAccessor(AbstractRule rule) {
        String _gaRuleElementsMethodName = this.gaRuleElementsMethodName(rule);
        return _gaRuleElementsMethodName + "()";
    }

    public String gaBaseElementsAccessor(AbstractRule rule) {
        String _gaBaseRuleElementsMethodName = this.gaBaseRuleElementsMethodName(rule);
        return _gaBaseRuleElementsMethodName + "()";
    }

    public String gaElementAccessor(AbstractElement ele) {
        String _gaElementAccessMethodName = this.gaElementAccessMethodName(ele);
        return _gaElementAccessMethodName + "()";
    }

    public String gaRuleElementAccessor(AbstractElement ele) {
        String _gaElementsAccessor = this.gaElementsAccessor(GrammarUtil.containingRule((EObject)ele));
        String _plus = _gaElementsAccessor + ".";
        String _gaElementAccessor = this.gaElementAccessor(ele);
        return _plus + _gaElementAccessor;
    }

    public String gaTypeAccessor(TypeRef ele) {
        EObject _eContainer;
        String _switchResult = null;
        EObject cnt = _eContainer = ele.eContainer();
        boolean _matched = false;
        if (cnt instanceof AbstractElement) {
            _matched = true;
            String _gaRuleElementAccessor = this.gaRuleElementAccessor((AbstractElement)cnt);
            _switchResult = _gaRuleElementAccessor + ".getType()";
        }
        if (!_matched && cnt instanceof AbstractRule) {
            _matched = true;
            String _gaRuleAccessor = this.gaRuleAccessor((AbstractRule)cnt);
            _switchResult = _gaRuleAccessor + ".getType()";
        }
        if (!_matched) {
            String _name = ele.eContainer().eClass().getName();
            String _plus = "<error: unknown type " + _name;
            _switchResult = _plus + ">";
        }
        return _switchResult;
    }

    public String gaAccessor(EObject ele) {
        Object _switchResult = null;
        boolean _matched = false;
        if (ele instanceof AbstractElement) {
            _matched = true;
            _switchResult = this.gaRuleElementAccessor((AbstractElement)ele);
        }
        if (!_matched && ele instanceof AbstractRule) {
            _matched = true;
            _switchResult = this.gaRuleAccessor((AbstractRule)ele);
        }
        if (!_matched && ele instanceof Parameter) {
            _matched = true;
            _switchResult = this.gaRuleParameterAccessor((Parameter)ele);
        }
        if (!_matched) {
            String _name = ele.eClass().getName();
            String _plus = "<error: unknown type " + _name;
            _switchResult = _plus + ">";
        }
        return _switchResult;
    }

    public String grammarFragmentToString(EObject object, String prefix) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)object);
        if (node == null) {
            if (object instanceof RuleCall) {
                boolean _tripleNotEquals;
                AbstractRule _rule = null;
                if ((RuleCall)object != null) {
                    _rule = ((RuleCall)object).getRule();
                }
                String _name = null;
                if (_rule != null) {
                    _name = _rule.getName();
                }
                boolean bl = _tripleNotEquals = _name != null;
                if (_tripleNotEquals) {
                    return this.process(((RuleCall)object).getRule().getName(), prefix);
                }
            }
            return "";
        }
        return this.process(node.getText(), prefix);
    }

    private String process(String input, String prefix) {
        boolean _equals;
        String[] lines = input.split("\\s*(\\r?\\n)");
        int first = 0;
        while (this.isBlank(lines[first])) {
            ++first;
        }
        int _length = lines.length;
        int last = _length - 1;
        while (this.isBlank(lines[last])) {
            --last;
        }
        String[] _converted_lines = lines;
        lines = (String[])Conversions.unwrapArray(((List)Conversions.doWrapArray((Object)_converted_lines)).subList(first, last + 1), String.class);
        String[] _converted_lines_1 = lines;
        int _size = ((List)Conversions.doWrapArray((Object)_converted_lines_1)).size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            String _trim = lines[0].trim();
            return prefix + _trim;
        }
        String[] _converted_lines_2 = lines;
        String commonWhitespace = this.commonLeadingWhitespace((List)Conversions.doWrapArray((Object)_converted_lines_2));
        int n = 0;
        while (n < lines.length) {
            String _substring = lines[n].replaceAll("\t", "    ").substring(commonWhitespace.length());
            String _plus = prefix + _substring;
            lines[n] = _plus;
            ++n;
        }
        String[] _converted_lines_3 = lines;
        return IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_lines_3)), (CharSequence)this.codeConfig.getLineDelimiter());
    }

    private boolean isBlank(String line) {
        return line.trim().isEmpty();
    }

    private String commonLeadingWhitespace(List<String> lines) {
        boolean _isBlank;
        String next;
        boolean _lessThan;
        int _size = lines.size();
        boolean bl = _lessThan = _size < 2;
        if (_lessThan) {
            return "";
        }
        String current = Strings.repeat((String)" ", (int)lines.get(0).replaceAll("\t", "    ").length());
        int i = 0;
        while (i < ((Object[])Conversions.unwrapArray(lines, Object.class)).length) {
            boolean _not;
            next = lines.get(i).replaceAll("\t", "    ");
            _isBlank = this.isBlank(next);
            boolean bl2 = _not = !_isBlank;
            if (_not) {
                current = Strings.commonPrefix((CharSequence)current, (CharSequence)next);
            }
            ++i;
        }
        i = 0;
        while (i < ((Object[])Conversions.unwrapArray(lines, Object.class)).length) {
            next = lines.get(i).replaceAll("\t", "    ");
            _isBlank = this.isBlank(next);
            if (_isBlank) {
                lines.set(i, current);
            }
            ++i;
        }
        return current;
    }

    public static String grammarFragmentToString(ISerializer serializer, EObject object, String prefix) {
        Object s = null;
        try {
            SaveOptions options = SaveOptions.newBuilder().format().getOptions();
            s = serializer.serialize(object, options);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                s = e.toString();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        String _replace = ((String)s).trim().replaceAll("(\\r?\\n)", "$1" + prefix).replace("\\u", "\\\\u");
        String _plus = prefix + _replace;
        s = _plus;
        return s;
    }

    protected String _grammarElementIdentifier(EObject it) {
        String _string = it.toString();
        return "Unsupported : grammarElementIdentifier for: " + _string;
    }

    protected String _grammarElementIdentifier(AbstractRule it) {
        return this.gaRuleIdentifier(it);
    }

    protected String _grammarElementIdentifier(AbstractElement it) {
        String _grammarElementIdentifier = this.grammarElementIdentifier((EObject)GrammarUtil.containingRule((EObject)it));
        String _plus = _grammarElementIdentifier + "_";
        String _gaElementIdentifier = this.gaElementIdentifier(it);
        return _plus + _gaElementIdentifier;
    }

    protected String _grammarElementAccess(EObject it) {
        String _string = it.toString();
        return "Unsupported : grammarElementAccess for: " + _string;
    }

    protected String _grammarElementAccess(AbstractRule it) {
        return this.gaRuleAccessor(it);
    }

    protected String _grammarElementAccess(AbstractElement it) {
        return this.gaRuleElementAccessor(it);
    }

    public List<String> initialHiddenTokens(Grammar it) {
        boolean _equals;
        List _xblockexpression = null;
        boolean _isDefinesHiddenTokens = it.isDefinesHiddenTokens();
        if (_isDefinesHiddenTokens) {
            Functions.Function1 _function = it_1 -> this.ruleName((AbstractRule)it_1);
            return IterableExtensions.toList((Iterable)ListExtensions.map((List)it.getHiddenTokens(), (Functions.Function1)_function));
        }
        int _size = it.getUsedGrammars().size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            return this.initialHiddenTokens((Grammar)IterableExtensions.head((Iterable)it.getUsedGrammars()));
        }
        _xblockexpression = CollectionLiterals.emptyList();
        return _xblockexpression;
    }

    public String ruleName(AbstractRule rule) {
        String _ruleName;
        RuleNames ruleNames = RuleNames.tryGetRuleNames((AbstractRule)rule);
        String _elvis = null;
        String _antlrRuleName = null;
        if (ruleNames != null) {
            _antlrRuleName = ruleNames.getAntlrRuleName(rule);
        }
        _elvis = _antlrRuleName != null ? _antlrRuleName : (_ruleName = AntlrGrammarGenUtil.getRuleName(rule));
        return _elvis;
    }

    public String entryRuleName(ParserRule rule) {
        return AntlrGrammarGenUtil.getEntryRuleName(rule);
    }

    public boolean isCalled(AbstractRule rule, Grammar grammar) {
        boolean _xblockexpression = false;
        List allRules = GrammarUtil.allRules((Grammar)grammar);
        _xblockexpression = allRules.indexOf(rule) == 0 || IterableExtensions.exists((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)allRules, it -> GrammarUtil.containedRuleCalls((EObject)it))), ruleCall -> {
            AbstractRule _rule = ruleCall.getRule();
            return Objects.equals(_rule, rule);
        });
        return _xblockexpression;
    }

    public boolean definesUnorderedGroups(ParserRule it, AntlrOptions options) {
        return options.isBacktrack() && !EcoreUtil2.typeSelect((List)EcoreUtil2.eAllContentsAsList((EObject)it), UnorderedGroup.class).isEmpty();
    }

    protected boolean _predicated(AbstractElement it) {
        return it.isPredicated();
    }

    protected boolean _predicated(Assignment it) {
        return it.isPredicated() || this.predicated(it.getTerminal());
    }

    protected boolean _predicated(RuleCall it) {
        boolean _or = false;
        boolean _isPredicated = it.isPredicated();
        if (_isPredicated) {
            _or = true;
        } else {
            boolean _xblockexpression = false;
            AbstractElement group = it.getRule().getAlternatives();
            boolean _xifexpression = false;
            _xifexpression = group instanceof Group ? this.predicated((AbstractElement)IterableExtensions.head((Iterable)((Group)group).getElements())) : false;
            _or = _xblockexpression = _xifexpression;
        }
        return _or;
    }

    public AbstractElement predicatedElement(AbstractElement it) {
        return AntlrGrammarGenUtil.getPredicatedElement(it);
    }

    public String localVar(Assignment it, AbstractElement terminal) {
        String _feature = it.getFeature();
        String _plus = "lv_" + _feature;
        String _plus_1 = _plus + "_";
        int _indexOf = this.contentsAsList((EObject)GrammarUtil.containingParserRule((EObject)it)).indexOf(it);
        String _plus_2 = _plus_1 + String.valueOf((Object)_indexOf);
        String _plus_3 = _plus_2 + "_";
        int _indexOf_1 = EcoreUtil2.eAllContentsAsList((EObject)it).indexOf(terminal);
        return _plus_3 + String.valueOf((Object)_indexOf_1);
    }

    protected String _localVar(RuleCall it) {
        String _name = AntlrGrammarGenUtil.getOriginalElement(it.getRule()).getName();
        String _plus = "this_" + _name;
        String _plus_1 = _plus + "_";
        int _indexOf = this.contentsAsList((EObject)GrammarUtil.containingParserRule((EObject)it)).indexOf(it);
        return _plus_1 + String.valueOf((Object)_indexOf);
    }

    protected String _localVar(AbstractElement it) {
        String _xblockexpression = null;
        ParserRule rule = GrammarUtil.containingParserRule((EObject)it);
        int index = this.contentsAsList((EObject)rule).indexOf(it);
        _xblockexpression = "otherlv_" + String.valueOf((Object)index);
        return _xblockexpression;
    }

    protected String _localVar(EnumLiteralDeclaration it) {
        int _indexOf = this.contentsAsList((EObject)GrammarUtil.containingEnumRule((EObject)it).getAlternatives()).indexOf(it);
        return "enumLiteral_" + String.valueOf((Object)_indexOf);
    }

    protected List<AbstractElement> _contentsAsList(ParserRule it) {
        return this.contentsAsList((EObject)it.getAlternatives());
    }

    protected List<AbstractElement> _contentsAsList(AbstractElement it) {
        return CollectionLiterals.newArrayList((Object[])new AbstractElement[]{it});
    }

    protected List<AbstractElement> _contentsAsList(CompoundElement it) {
        Functions.Function1 _function = it_1 -> this.contentsAsList((EObject)it_1);
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)it.getElements(), (Functions.Function1)_function)));
    }

    protected List<AbstractElement> _contentsAsList(UnorderedGroup it) {
        ArrayList _xblockexpression = null;
        ArrayList result = CollectionLiterals.newArrayList((Object[])new AbstractElement[]{it});
        Functions.Function1 _function = it_1 -> this.contentsAsList((EObject)it_1);
        List _list = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)it.getElements(), (Functions.Function1)_function)));
        Iterables.addAll((Collection)result, (Iterable)_list);
        _xblockexpression = result;
        return _xblockexpression;
    }

    public String setOrAdd(Action it) {
        String _xifexpression = null;
        String _operator = it.getOperator();
        boolean _equals = Objects.equals(_operator, "+=");
        _xifexpression = _equals ? "add" : "set";
        return _xifexpression;
    }

    public String setOrAdd(Assignment it) {
        String _xifexpression = null;
        String _operator = it.getOperator();
        boolean _equals = Objects.equals(_operator, "+=");
        _xifexpression = _equals ? "add" : "set";
        return _xifexpression;
    }

    public CharSequence toStringLiteral(AbstractElement it) {
        String _switchResult = null;
        boolean _matched = false;
        if (it instanceof RuleCall) {
            boolean _tripleNotEquals;
            AbstractRule _rule = ((RuleCall)it).getRule();
            boolean bl = _tripleNotEquals = _rule != null;
            if (_tripleNotEquals) {
                _matched = true;
                _switchResult = AntlrGrammarGenUtil.getQualifiedNameAsString((RuleCall)it);
            }
        }
        if (!_matched && it instanceof Keyword) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("\"");
            String _stringInAntlrAction = AntlrGrammarGenUtil.toStringInAntlrAction(((Keyword)it).getValue());
            _builder.append(_stringInAntlrAction);
            _builder.append("\"");
            _switchResult = _builder;
        }
        if (!_matched) {
            _switchResult = "null";
        }
        return _switchResult;
    }

    @XbaseGenerated
    public String grammarElementIdentifier(EObject it) {
        if (it instanceof AbstractElement) {
            return this._grammarElementIdentifier((AbstractElement)it);
        }
        if (it instanceof AbstractRule) {
            return this._grammarElementIdentifier((AbstractRule)it);
        }
        if (it != null) {
            return this._grammarElementIdentifier(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public String grammarElementAccess(EObject it) {
        if (it instanceof AbstractElement) {
            return this._grammarElementAccess((AbstractElement)it);
        }
        if (it instanceof AbstractRule) {
            return this._grammarElementAccess((AbstractRule)it);
        }
        if (it != null) {
            return this._grammarElementAccess(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public boolean predicated(AbstractElement it) {
        if (it instanceof Assignment) {
            return this._predicated((Assignment)it);
        }
        if (it instanceof RuleCall) {
            return this._predicated((RuleCall)it);
        }
        if (it != null) {
            return this._predicated(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public String localVar(AbstractElement it) {
        if (it instanceof EnumLiteralDeclaration) {
            return this._localVar((EnumLiteralDeclaration)it);
        }
        if (it instanceof RuleCall) {
            return this._localVar((RuleCall)it);
        }
        if (it != null) {
            return this._localVar(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public List<AbstractElement> contentsAsList(EObject it) {
        if (it instanceof UnorderedGroup) {
            return this._contentsAsList((UnorderedGroup)it);
        }
        if (it instanceof CompoundElement) {
            return this._contentsAsList((CompoundElement)it);
        }
        if (it instanceof ParserRule) {
            return this._contentsAsList((ParserRule)it);
        }
        if (it instanceof AbstractElement) {
            return this._contentsAsList((AbstractElement)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @FinalFieldsConstructor
    protected static class LineSeparatorModule
    extends XtextRuntimeModule {
        private final ILineSeparatorInformation lineSeparatorInformation;

        public void configure(Binder binder) {
            CompoundModule compound = this.getBindings();
            compound.configure(binder);
        }

        public ILineSeparatorInformation bindILineSeparatorInformation() {
            return this.lineSeparatorInformation;
        }

        public LineSeparatorModule(ILineSeparatorInformation lineSeparatorInformation) {
            this.lineSeparatorInformation = lineSeparatorInformation;
        }
    }
}

