/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.archetype.model.Resource;
import org.apache.maven.archetype.model.Source;

public class ArchetypeModel
implements Serializable {
    private String id;
    private boolean allowPartial = false;
    private List<Source> sources;
    private List<Resource> resources;
    private List<Source> testSources;
    private List<Resource> testResources;
    private List<Resource> siteResources;
    private String modelEncoding = "UTF-8";

    public void addResource(Resource resource) {
        this.getResources().add(resource);
    }

    public void addSiteResource(Resource resource) {
        this.getSiteResources().add(resource);
    }

    public void addSource(Source source) {
        this.getSources().add(source);
    }

    public void addTestResource(Resource resource) {
        this.getTestResources().add(resource);
    }

    public void addTestSource(Source source) {
        this.getTestSources().add(source);
    }

    public String getId() {
        return this.id;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public List<Resource> getResources() {
        if (this.resources == null) {
            this.resources = new ArrayList<Resource>();
        }
        return this.resources;
    }

    public List<Resource> getSiteResources() {
        if (this.siteResources == null) {
            this.siteResources = new ArrayList<Resource>();
        }
        return this.siteResources;
    }

    public List<Source> getSources() {
        if (this.sources == null) {
            this.sources = new ArrayList<Source>();
        }
        return this.sources;
    }

    public List<Resource> getTestResources() {
        if (this.testResources == null) {
            this.testResources = new ArrayList<Resource>();
        }
        return this.testResources;
    }

    public List<Source> getTestSources() {
        if (this.testSources == null) {
            this.testSources = new ArrayList<Source>();
        }
        return this.testSources;
    }

    public boolean isAllowPartial() {
        return this.allowPartial;
    }

    public void removeResource(Resource resource) {
        this.getResources().remove(resource);
    }

    public void removeSiteResource(Resource resource) {
        this.getSiteResources().remove(resource);
    }

    public void removeSource(Source source) {
        this.getSources().remove(source);
    }

    public void removeTestResource(Resource resource) {
        this.getTestResources().remove(resource);
    }

    public void removeTestSource(Source source) {
        this.getTestSources().remove(source);
    }

    public void setAllowPartial(boolean allowPartial) {
        this.allowPartial = allowPartial;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public void setSiteResources(List<Resource> siteResources) {
        this.siteResources = siteResources;
    }

    public void setSources(List<Source> sources) {
        this.sources = sources;
    }

    public void setTestResources(List<Resource> testResources) {
        this.testResources = testResources;
    }

    public void setTestSources(List<Source> testSources) {
        this.testSources = testSources;
    }
}

