/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.wizards;

import aQute.bnd.osgi.Jar;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.bndtools.api.ILogger;
import org.bndtools.api.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.bnd.ui.FileExtensionFilter;
import org.eclipse.pde.bnd.ui.Resources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class AddFilesToRepositoryWizardPage
extends WizardPage {
    private static final ILogger logger = Logger.getLogger(AddFilesToRepositoryWizardPage.class);
    private static final Image jarImg = Resources.getImage("jar.gif");
    private static final Image warnImg = Resources.getImage("warning_obj.gif");
    private static final Image errorImg = Resources.getImage("error.gif");
    private static final Image okayImg = Resources.getImage("tick.png");
    private final Map<File, Map.Entry<String, String>> bsnMap = new HashMap<File, Map.Entry<String, String>>();
    private final List<File> files = new ArrayList<File>(1);
    private TableViewer viewer;

    public AddFilesToRepositoryWizardPage(String pageName) {
        super(pageName);
    }

    public void setFiles(File[] files) {
        this.files.clear();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.analyseFile(file);
            this.files.add(file);
            ++n2;
        }
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.refresh();
            this.validate();
        }
    }

    public List<File> getFiles() {
        return this.files;
    }

    void analyseFile(File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Jar jar = new Jar(file);){
                Attributes attribs = jar.getManifest().getMainAttributes();
                String bsn = attribs.getValue("Bundle-SymbolicName");
                String version = attribs.getValue("Bundle-Version");
                this.bsnMap.put(file, Map.entry(bsn, version));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.logError("Error reading JAR file content", (Throwable)e);
        }
    }

    public void createControl(Composite parent) {
        this.setTitle("Add Files to Repository");
        Composite composite = new Composite(parent, 0);
        new Label(composite, 0).setText("Selected files:");
        new Label(composite, 0);
        Table table = new Table(composite, 67586);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn col = new TableColumn(table, 0);
        col.setText("Path");
        col.setWidth(300);
        col = new TableColumn(table, 0);
        col.setText("Bundle Name/Version");
        col.setWidth(300);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                File file = (File)cell.getElement();
                Map.Entry<String, String> bundleId = AddFilesToRepositoryWizardPage.this.bsnMap.get(file);
                int index = cell.getColumnIndex();
                if (index == 0) {
                    if (bundleId == null) {
                        cell.setImage(errorImg);
                    } else {
                        cell.setImage(jarImg);
                    }
                    StyledString label = new StyledString(file.getName());
                    String parentPath = file.getParent();
                    if (parentPath != null) {
                        label.append(" (" + parentPath + ")", StyledString.QUALIFIER_STYLER);
                    }
                    cell.setText(label.getString());
                    cell.setStyleRanges(label.getStyleRanges());
                } else if (index == 1) {
                    if (bundleId == null) {
                        cell.setImage(errorImg);
                        cell.setText("Not a JAR file");
                    } else {
                        String bsn = bundleId.getKey();
                        String version = bundleId.getValue();
                        if (bsn == null) {
                            cell.setImage(warnImg);
                            cell.setText("Not a Bundle JAR");
                        } else {
                            cell.setImage(okayImg);
                            StyledString styledString = new StyledString(bsn);
                            if (version != null) {
                                styledString.append(" [" + version + "]", StyledString.COUNTER_STYLER);
                                cell.setText(styledString.getString());
                                cell.setStyleRanges(styledString.getStyleRanges());
                            }
                        }
                    }
                }
            }
        });
        this.viewer.setInput(this.files);
        this.validate();
        Button btnAdd = new Button(composite, 8);
        btnAdd.setText("Add JARs...");
        Button btnAddExternal = new Button(composite, 8);
        btnAddExternal.setText("Add External JARs...");
        Button btnRemove = new Button(composite, 0);
        btnRemove.setText("Remove");
        btnRemove.setEnabled(false);
        this.viewer.addSelectionChangedListener(event -> btnRemove.setEnabled(!this.viewer.getSelection().isEmpty()));
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddFilesToRepositoryWizardPage.this.doAdd();
            }
        });
        btnAddExternal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddFilesToRepositoryWizardPage.this.doAddExternal();
            }
        });
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddFilesToRepositoryWizardPage.this.doRemove();
            }
        });
        composite.setLayout((Layout)new GridLayout(2, false));
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 4));
        btnAdd.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        btnRemove.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.setControl((Control)composite);
    }

    void doAdd() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator(selection -> {
            if (selection.length > 0 && selection[0] instanceof IFile) {
                return Status.OK_STATUS;
            }
            return Status.error((String)"");
        });
        dialog.setAllowMultiple(true);
        dialog.setTitle("JAR File Selection");
        dialog.addFilter((ViewerFilter)new FileExtensionFilter("jar"));
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            ArrayList<File> added = new ArrayList<File>(result.length);
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object fileObj = objectArray[n2];
                IFile ifile = (IFile)fileObj;
                File file = ifile.getLocation().toFile();
                this.analyseFile(file);
                this.files.add(file);
                added.add(file);
                ++n2;
            }
            if (!added.isEmpty()) {
                this.viewer.add(added.toArray());
                this.validate();
            }
        }
    }

    void doAddExternal() {
        FileDialog dialog = new FileDialog(this.getShell(), 4098);
        dialog.setFilterExtensions(new String[]{"*.jar"});
        String res = dialog.open();
        if (res != null) {
            Path filterPath = new Path(dialog.getFilterPath());
            String[] fileNames = dialog.getFileNames();
            ArrayList<File> added = new ArrayList<File>(fileNames.length);
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                added.add(filterPath.append(fileName).toFile());
                ++n2;
            }
            if (!added.isEmpty()) {
                for (File addedFile : added) {
                    this.analyseFile(addedFile);
                    this.files.add(addedFile);
                }
                this.viewer.add(added.toArray());
                this.validate();
            }
        }
    }

    void doRemove() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            for (Object item : selection) {
                this.files.remove(item);
                this.viewer.remove(item);
            }
            this.validate();
        }
    }

    void validate() {
        String error = null;
        String warning = null;
        for (File file : this.files) {
            Map.Entry<String, String> pair = this.bsnMap.get(file);
            if (pair == null) {
                error = "One or more selected files is not a JAR.";
                continue;
            }
            String bsn = pair.getKey();
            if (bsn != null) continue;
            warning = "One or more selected files is not a Bundle JAR";
        }
        this.setErrorMessage(error);
        this.setMessage(warning, 2);
        this.setPageComplete(!this.files.isEmpty() && error == null);
    }
}

