/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gpg.bc.internal.keys;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;

public final class ObjectIds {
    public static final ASN1ObjectIdentifier OID_OPENPGP_ED25519 = new ASN1ObjectIdentifier("1.3.6.1.4.1.11591.15.1");
    public static final ASN1ObjectIdentifier OID_RFC8410_ED25519 = new ASN1ObjectIdentifier("1.3.101.112");
    public static final ASN1ObjectIdentifier OID_OPENPGP_CURVE25519 = ECNamedCurveTable.getOID((String)"curve25519");
    public static final ASN1ObjectIdentifier OID_RFC8410_CURVE25519 = new ASN1ObjectIdentifier("1.3.101.110");

    public static boolean isEd25519(ASN1ObjectIdentifier oid) {
        return OID_OPENPGP_ED25519.equals((ASN1Primitive)oid) || OID_RFC8410_ED25519.equals((ASN1Primitive)oid);
    }

    public static boolean isCurve25519(ASN1ObjectIdentifier oid) {
        return OID_RFC8410_CURVE25519.equals((ASN1Primitive)oid) || OID_OPENPGP_CURVE25519.equals((ASN1Primitive)oid);
    }

    public static ASN1ObjectIdentifier getByName(String name) {
        block10: {
            if (name == null) break block10;
            switch (name) {
                case "Ed25519": {
                    return OID_OPENPGP_ED25519;
                }
                case "Curve25519": {
                    return OID_OPENPGP_CURVE25519;
                }
            }
        }
        return null;
    }

    public static boolean match(ASN1ObjectIdentifier oid1, ASN1ObjectIdentifier oid2) {
        if (ObjectIds.isEd25519(oid1)) {
            return ObjectIds.isEd25519(oid2);
        }
        if (ObjectIds.isCurve25519(oid1)) {
            return ObjectIds.isCurve25519(oid2);
        }
        return oid1 != null && oid1.equals((ASN1Primitive)oid2);
    }
}

