/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.commands;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.ui.CatalogRegistry;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiResources;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.catalog.ResourceProvider;
import org.eclipse.epp.internal.mpc.ui.commands.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.AbstractMarketplaceWizardDialog;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.mpc.core.model.ICatalog;
import org.eclipse.epp.mpc.core.service.ICatalogService;
import org.eclipse.epp.mpc.core.service.ServiceHelper;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.epp.mpc.ui.IMarketplaceClientConfiguration;
import org.eclipse.equinox.internal.p2.discovery.DiscoveryCore;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractMarketplaceWizardCommand
extends AbstractHandler
implements IHandler {
    private List<CatalogDescriptor> catalogDescriptors;
    private CatalogDescriptor selectedCatalogDescriptor;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        MarketplaceCatalog catalog = this.createCatalog();
        if (catalog == null) {
            return null;
        }
        MarketplaceCatalogConfiguration configuration = this.createConfiguration(catalog, event);
        if (configuration == null) {
            return null;
        }
        DiscoveryWizard wizard = this.createWizard(catalog, configuration, event);
        this.openWizardDialog(wizard, event);
        return null;
    }

    protected MarketplaceCatalog createCatalog() {
        MarketplaceCatalog catalog = new MarketplaceCatalog();
        catalog.setEnvironment(DiscoveryCore.createEnvironment());
        catalog.setVerifyUpdateSiteAvailability(false);
        return catalog;
    }

    protected MarketplaceCatalogConfiguration createConfiguration(MarketplaceCatalog catalog, ExecutionEvent event) {
        MarketplaceCatalogConfiguration configuration = new MarketplaceCatalogConfiguration();
        configuration.setVerifyUpdateSiteAvailability(false);
        if (this.catalogDescriptors == null || this.catalogDescriptors.isEmpty()) {
            IStatus remoteCatalogStatus = this.installRemoteCatalogs();
            configuration.getCatalogDescriptors().addAll(CatalogRegistry.getInstance().getCatalogDescriptors());
            if (configuration.getCatalogDescriptors().isEmpty()) {
                Object cause = !remoteCatalogStatus.isOK() ? remoteCatalogStatus : new Status(4, "org.eclipse.epp.mpc.ui", Messages.MarketplaceWizardCommand_noRemoteCatalogs);
                Status exitStatus = new Status(4, "org.eclipse.epp.mpc.ui", cause.getCode(), Messages.MarketplaceWizardCommand_cannotOpenMarketplace, (Throwable)new CoreException(cause));
                try {
                    MarketplaceClientUi.handle((IStatus)exitStatus, 6 | (exitStatus.getSeverity() == 8 ? 0 : 1));
                }
                catch (Exception ex) {
                    MarketplaceClientUi.getLog().log((IStatus)exitStatus);
                }
                return null;
            }
            if (!remoteCatalogStatus.isOK()) {
                MarketplaceClientUi.handle(remoteCatalogStatus, 1);
            }
        } else {
            configuration.getCatalogDescriptors().addAll(this.catalogDescriptors);
        }
        if (this.selectedCatalogDescriptor != null) {
            if (this.selectedCatalogDescriptor.getLabel().equals("org.eclipse.epp.mpc.descriptorHint")) {
                CatalogDescriptor resolvedDescriptor = CatalogRegistry.getInstance().findCatalogDescriptor(this.selectedCatalogDescriptor.getUrl().toExternalForm());
                if (resolvedDescriptor == null) {
                    Status status = new Status(4, "org.eclipse.epp.mpc.ui", Messages.MarketplaceWizardCommand_CouldNotFindMarketplaceForSolution, (Throwable)new ExecutionException(this.selectedCatalogDescriptor.getUrl().toExternalForm()));
                    MarketplaceClientUi.handle((IStatus)status, 7);
                    return null;
                }
                configuration.setCatalogDescriptor(resolvedDescriptor);
            } else {
                configuration.setCatalogDescriptor(this.selectedCatalogDescriptor);
            }
        }
        return configuration;
    }

    protected void openWizardDialog(DiscoveryWizard wizard, ExecutionEvent event) {
        AbstractMarketplaceWizardDialog dialog = this.createWizardDialog(wizard, event);
        dialog.open();
    }

    protected abstract AbstractMarketplaceWizardDialog createWizardDialog(DiscoveryWizard var1, ExecutionEvent var2);

    protected abstract DiscoveryWizard createWizard(MarketplaceCatalog var1, MarketplaceCatalogConfiguration var2, ExecutionEvent var3);

    public void setCatalogDescriptors(List<CatalogDescriptor> catalogDescriptors) {
        this.catalogDescriptors = catalogDescriptors;
    }

    public void setSelectedCatalogDescriptor(CatalogDescriptor selectedCatalogDescriptor) {
        this.selectedCatalogDescriptor = selectedCatalogDescriptor;
    }

    public IStatus installRemoteCatalogs() {
        try {
            AtomicReference result = new AtomicReference();
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(monitor -> {
                try {
                    ICatalogService catalogService = ServiceHelper.getMarketplaceServiceLocator().getCatalogService();
                    List catalogs = catalogService.listCatalogs(monitor);
                    result.set(catalogs);
                }
                catch (CoreException e) {
                    if (e.getStatus().getSeverity() == 8) {
                        throw new InterruptedException();
                    }
                    throw new InvocationTargetException(e);
                }
            });
            List catalogs = (List)result.get();
            for (ICatalog catalog : catalogs) {
                ResourceProvider resourceProvider = MarketplaceClientUiResources.getInstance().getResourceProvider();
                String catalogName = catalog.getName();
                String requestSource = NLS.bind((String)Messages.MarketplaceWizardCommand_requestCatalog, (Object)catalogName, (Object)catalog.getId());
                String catalogImageUrl = catalog.getImageUrl();
                if (catalogImageUrl != null) {
                    try {
                        resourceProvider.retrieveResource(requestSource, catalogImageUrl);
                    }
                    catch (Exception e) {
                        MarketplaceClientUi.log(2, Messages.MarketplaceWizardCommand_FailedRetrievingCatalogImage, catalogName, catalogImageUrl, e);
                    }
                }
                if (catalog.getBranding() != null && catalog.getBranding().getWizardIcon() != null) {
                    String wizardIconUrl = catalog.getBranding().getWizardIcon();
                    try {
                        resourceProvider.retrieveResource(requestSource, wizardIconUrl);
                    }
                    catch (Exception e) {
                        MarketplaceClientUi.log(2, Messages.MarketplaceWizardCommand_FailedRetrievingCatalogWizardIcon, catalogName, wizardIconUrl, e);
                    }
                }
                CatalogDescriptor descriptor = new CatalogDescriptor(catalog);
                this.registerOrOverrideCatalog(descriptor);
            }
        }
        catch (InterruptedException ie) {
            if (ie.getMessage() == null || "".equals(ie.getMessage())) {
                InterruptedException ie1 = new InterruptedException("Operation cancelled");
                ie1.setStackTrace(ie.getStackTrace());
                if (ie.getCause() != null) {
                    ie1.initCause(ie.getCause());
                }
                ie = ie1;
            }
            IStatus errorStatus = MarketplaceClientCore.computeStatus((Throwable)ie, (String)Messages.MarketplaceWizardCommand_CannotInstallRemoteLocations);
            return new Status(8, "org.eclipse.epp.mpc.core", errorStatus.getMessage(), (Throwable)ie);
        }
        catch (Exception e) {
            IStatus status = MarketplaceClientCore.computeStatus((Throwable)e, (String)Messages.MarketplaceWizardCommand_CannotInstallRemoteLocations);
            return status;
        }
        return Status.OK_STATUS;
    }

    private void registerOrOverrideCatalog(CatalogDescriptor descriptor) {
        CatalogRegistry catalogRegistry = CatalogRegistry.getInstance();
        List<CatalogDescriptor> descriptors = catalogRegistry.getCatalogDescriptors();
        for (CatalogDescriptor catalogDescriptor : descriptors) {
            if (!catalogDescriptor.getUrl().toExternalForm().equals(descriptor.getUrl().toExternalForm())) continue;
            catalogRegistry.unregister(catalogDescriptor);
        }
        catalogRegistry.register(descriptor);
    }

    public void setConfiguration(IMarketplaceClientConfiguration configuration) {
        this.setCatalogDescriptors(configuration.getCatalogDescriptors());
        this.setSelectedCatalogDescriptor(configuration.getCatalogDescriptor());
    }
}

